/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.saga.statelang.parser.impl;

import org.apache.seata.saga.statelang.domain.FailEndState;
import org.apache.seata.saga.statelang.domain.impl.FailEndStateImpl;
import org.apache.seata.saga.statelang.parser.StateParser;

import java.util.Map;

/**
 * Failed end state parser
 *
 */
public class FailEndStateParser extends BaseStatePaser implements StateParser<FailEndState> {

    @Override
    public FailEndState parse(Object node) {

        FailEndStateImpl failEndState = new FailEndStateImpl();
        parseBaseAttributes(failEndState, node);

        Map<String, Object> nodeMap = (Map<String, Object>) node;
        failEndState.setErrorCode((String) nodeMap.get("ErrorCode"));
        failEndState.setMessage((String) nodeMap.get("Message"));

        return failEndState;
    }
}
