/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.holder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.exception.ShouldNeverHappenException;

public enum ObjectHolder {
    INSTANCE;

    private static final int MAP_SIZE = 8;
    private static final Map<String, Object> OBJECT_MAP;

    public Object getObject(String objectKey) {
        return OBJECT_MAP.get(objectKey);
    }

    public <T> T getObject(Class<T> clasz) {
        return clasz.cast(OBJECT_MAP.values().stream().filter(clasz::isInstance).findAny().orElseThrow(() -> new ShouldNeverHappenException("Can't find any object of class " + clasz.getName())));
    }

    public Object setObject(String objectKey, Object object) {
        return OBJECT_MAP.put(objectKey, object);
    }

    static {
        OBJECT_MAP = new ConcurrentHashMap<String, Object>(8);
    }
}

