/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;

public class AwsIamServiceIdentityInfo
extends ServiceIdentityInfo {
    @NotNull
    private final String iamArn;

    @ApiModelProperty(example="arn:aws:iam::111122223333:user/polaris-service-user", required=true, value="The ARN of the IAM user or IAM role Polaris uses to assume roles and then access external resources.")
    @JsonProperty(value="iamArn", required=true)
    public String getIamArn() {
        return this.iamArn;
    }

    @JsonCreator
    public AwsIamServiceIdentityInfo(@JsonProperty(value="iamArn", required=true) String iamArn, @JsonProperty(value="identityType", required=true) ServiceIdentityInfo.IdentityTypeEnum identityType) {
        super(identityType);
        this.iamArn = iamArn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String iamArn, ServiceIdentityInfo.IdentityTypeEnum identityType) {
        return new Builder(iamArn, identityType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsIamServiceIdentityInfo awsIamServiceIdentityInfo = (AwsIamServiceIdentityInfo)o;
        return super.equals(o) && Objects.equals(this.iamArn, awsIamServiceIdentityInfo.iamArn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.iamArn);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AwsIamServiceIdentityInfo {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    iamArn: ").append(this.toIndentedString(this.iamArn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String iamArn;
        private ServiceIdentityInfo.IdentityTypeEnum identityType;

        private Builder() {
        }

        private Builder(String iamArn, ServiceIdentityInfo.IdentityTypeEnum identityType) {
            this.iamArn = iamArn;
            this.identityType = identityType;
        }

        public Builder setIamArn(String iamArn) {
            this.iamArn = iamArn;
            return this;
        }

        public Builder setIdentityType(ServiceIdentityInfo.IdentityTypeEnum identityType) {
            this.identityType = identityType;
            return this;
        }

        public AwsIamServiceIdentityInfo build() {
            AwsIamServiceIdentityInfo inst = new AwsIamServiceIdentityInfo(this.iamArn, this.identityType);
            return inst;
        }
    }
}

