/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimap;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.schema.UnionByNameVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaUpdate
implements UpdateSchema {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaUpdate.class);
    private static final int TABLE_ROOT_ID = -1;
    private final TableOperations ops;
    private final TableMetadata base;
    private final Schema schema;
    private final Map<Integer, Integer> idToParent;
    private final List<Integer> deletes = Lists.newArrayList();
    private final Map<Integer, Types.NestedField> updates = Maps.newHashMap();
    private final Multimap<Integer, Integer> parentToAddedIds = Multimaps.newListMultimap((Map)Maps.newHashMap(), Lists::newArrayList);
    private final Map<String, Integer> addedNameToId = Maps.newHashMap();
    private final Multimap<Integer, Move> moves = Multimaps.newListMultimap((Map)Maps.newHashMap(), Lists::newArrayList);
    private int lastColumnId;
    private boolean allowIncompatibleChanges = false;
    private Set<String> identifierFieldNames;
    private boolean caseSensitive = true;

    SchemaUpdate(TableOperations ops) {
        this(ops, ops.current());
    }

    SchemaUpdate(Schema schema, int lastColumnId) {
        this(null, null, schema, lastColumnId);
    }

    private SchemaUpdate(TableOperations ops, TableMetadata base) {
        this(ops, base, base.schema(), base.lastColumnId());
    }

    private SchemaUpdate(TableOperations ops, TableMetadata base, Schema schema, int lastColumnId) {
        this.ops = ops;
        this.base = base;
        this.schema = schema;
        this.lastColumnId = lastColumnId;
        this.idToParent = Maps.newHashMap((Map)TypeUtil.indexParents((Types.StructType)schema.asStruct()));
        this.identifierFieldNames = schema.identifierFieldNames();
    }

    public SchemaUpdate allowIncompatibleChanges() {
        this.allowIncompatibleChanges = true;
        return this;
    }

    public UpdateSchema addColumn(String parent, String name, Type type, String doc, Literal<?> defaultValue) {
        this.internalAddColumn(parent, name, true, type, doc, defaultValue);
        return this;
    }

    public UpdateSchema addRequiredColumn(String parent, String name, Type type, String doc, Literal<?> defaultValue) {
        this.internalAddColumn(parent, name, false, type, doc, defaultValue);
        return this;
    }

    private void internalAddColumn(String parent, String name, boolean isOptional, Type type, String doc, Literal<?> defaultValue) {
        Object fullName;
        int parentId = -1;
        if (parent != null) {
            Types.NestedField parentField = this.findField(parent);
            Preconditions.checkArgument((parentField != null ? 1 : 0) != 0, (String)"Cannot find parent struct: %s", (Object)parent);
            Type parentType = parentField.type();
            if (parentType.isNestedType()) {
                Type.NestedType nested = parentType.asNestedType();
                if (nested.isMapType()) {
                    parentField = (Types.NestedField)nested.asMapType().fields().get(1);
                } else if (nested.isListType()) {
                    parentField = (Types.NestedField)nested.asListType().fields().get(0);
                }
            }
            Preconditions.checkArgument((parentField.type().isNestedType() && parentField.type().asNestedType().isStructType() ? 1 : 0) != 0, (String)"Cannot add to non-struct column: %s: %s", (Object)parent, (Object)parentField.type());
            parentId = parentField.fieldId();
            Types.NestedField currentField = this.findField(parent + "." + name);
            Preconditions.checkArgument((!this.deletes.contains(parentId) ? 1 : 0) != 0, (String)"Cannot add to a column that will be deleted: %s", (Object)parent);
            Preconditions.checkArgument((currentField == null || this.deletes.contains(currentField.fieldId()) ? 1 : 0) != 0, (String)"Cannot add column, name already exists: %s.%s", (Object)parent, (Object)name);
            fullName = this.schema.findColumnName(parentId) + "." + name;
        } else {
            Types.NestedField currentField = this.findField(name);
            Preconditions.checkArgument((currentField == null || this.deletes.contains(currentField.fieldId()) ? 1 : 0) != 0, (String)"Cannot add column, name already exists: %s", (Object)name);
            fullName = name;
        }
        Preconditions.checkArgument((defaultValue != null || isOptional || this.allowIncompatibleChanges ? 1 : 0) != 0, (String)"Incompatible change: cannot add required column without a default value: %s", (Object)fullName);
        int newId = this.assignNewColumnId();
        this.addedNameToId.put((String)fullName, newId);
        if (parentId != -1) {
            this.idToParent.put(newId, parentId);
        }
        Types.NestedField newField = Types.NestedField.builder().withName(name).isOptional(isOptional).withId(newId).ofType(TypeUtil.assignFreshIds((Type)type, this::assignNewColumnId)).withDoc(doc).withInitialDefault(defaultValue).withWriteDefault(defaultValue).build();
        this.updates.put(newId, newField);
        this.parentToAddedIds.put((Object)parentId, (Object)newId);
    }

    public UpdateSchema deleteColumn(String name) {
        Types.NestedField field = this.findField(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot delete missing column: %s", (Object)name);
        Preconditions.checkArgument((!this.parentToAddedIds.containsKey((Object)field.fieldId()) ? 1 : 0) != 0, (String)"Cannot delete a column that has additions: %s", (Object)name);
        Preconditions.checkArgument((!this.updates.containsKey(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot delete a column that has updates: %s", (Object)name);
        this.deletes.add(field.fieldId());
        return this;
    }

    public UpdateSchema renameColumn(String name, String newName) {
        Types.NestedField field = this.findField(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot rename missing column: %s", (Object)name);
        Preconditions.checkArgument((newName != null ? 1 : 0) != 0, (Object)"Cannot rename a column to null");
        Preconditions.checkArgument((!this.deletes.contains(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot rename a column that will be deleted: %s", (Object)field.name());
        int fieldId = field.fieldId();
        Types.NestedField update = this.updates.get(fieldId);
        Types.NestedField newField = Types.NestedField.from((Types.NestedField)(update != null ? update : field)).withName(newName).build();
        this.updates.put(fieldId, newField);
        if (this.identifierFieldNames.contains(name)) {
            this.identifierFieldNames.remove(name);
            this.identifierFieldNames.add(newName);
        }
        return this;
    }

    public UpdateSchema requireColumn(String name) {
        this.internalUpdateColumnRequirement(name, false);
        return this;
    }

    public UpdateSchema makeColumnOptional(String name) {
        this.internalUpdateColumnRequirement(name, true);
        return this;
    }

    private void internalUpdateColumnRequirement(String name, boolean isOptional) {
        Types.NestedField field = this.findForUpdate(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot update missing column: %s", (Object)name);
        if (!isOptional && field.isRequired() || isOptional && field.isOptional()) {
            return;
        }
        boolean isDefaultedAdd = this.isAdded(name) && field.initialDefault() != null;
        Preconditions.checkArgument((isOptional || isDefaultedAdd || this.allowIncompatibleChanges ? 1 : 0) != 0, (String)"Cannot change column nullability: %s: optional -> required", (Object)name);
        Preconditions.checkArgument((!this.deletes.contains(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot update a column that will be deleted: %s", (Object)field.name());
        int fieldId = field.fieldId();
        Types.NestedField.Builder builder = Types.NestedField.from((Types.NestedField)field);
        if (isOptional) {
            builder.asOptional();
        } else {
            builder.asRequired();
        }
        this.updates.put(fieldId, builder.build());
    }

    public UpdateSchema updateColumn(String name, Type.PrimitiveType newType) {
        Types.NestedField field = this.findForUpdate(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument((!this.deletes.contains(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot update a column that will be deleted: %s", (Object)field.name());
        if (field.type().equals(newType)) {
            return this;
        }
        Preconditions.checkArgument((boolean)TypeUtil.isPromotionAllowed((Type)field.type(), (Type.PrimitiveType)newType), (String)"Cannot change column type: %s: %s -> %s", (Object)name, (Object)field.type(), (Object)newType);
        int fieldId = field.fieldId();
        Types.NestedField newField = Types.NestedField.from((Types.NestedField)field).ofType((Type)newType).build();
        this.updates.put(fieldId, newField);
        return this;
    }

    public UpdateSchema updateColumnDoc(String name, String doc) {
        Types.NestedField field = this.findForUpdate(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument((!this.deletes.contains(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot update a column that will be deleted: %s", (Object)field.name());
        if (Objects.equals(field.doc(), doc)) {
            return this;
        }
        int fieldId = field.fieldId();
        Types.NestedField newField = Types.NestedField.from((Types.NestedField)field).withDoc(doc).build();
        this.updates.put(fieldId, newField);
        return this;
    }

    public UpdateSchema updateColumnDefault(String name, Literal<?> newDefault) {
        Literal converted;
        Types.NestedField field = this.findForUpdate(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument((!this.deletes.contains(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot update a column that will be deleted: %s", (Object)field.name());
        Literal literal = converted = newDefault != null ? newDefault.to(field.type()) : null;
        if (converted != null && Objects.equals(field.writeDefault(), converted.value())) {
            return this;
        }
        int fieldId = field.fieldId();
        Types.NestedField newField = Types.NestedField.from((Types.NestedField)field).withWriteDefault(newDefault).build();
        this.updates.put(fieldId, newField);
        return this;
    }

    public UpdateSchema moveFirst(String name) {
        Integer fieldId = this.findForMove(name);
        Preconditions.checkArgument((fieldId != null ? 1 : 0) != 0, (String)"Cannot move missing column: %s", (Object)name);
        this.internalMove(name, Move.first(fieldId));
        return this;
    }

    public UpdateSchema moveBefore(String name, String beforeName) {
        Integer fieldId = this.findForMove(name);
        Preconditions.checkArgument((fieldId != null ? 1 : 0) != 0, (String)"Cannot move missing column: %s", (Object)name);
        Integer beforeId = this.findForMove(beforeName);
        Preconditions.checkArgument((beforeId != null ? 1 : 0) != 0, (String)"Cannot move %s before missing column: %s", (Object)name, (Object)beforeName);
        Preconditions.checkArgument((!fieldId.equals(beforeId) ? 1 : 0) != 0, (String)"Cannot move %s before itself", (Object)name);
        this.internalMove(name, Move.before(fieldId, beforeId));
        return this;
    }

    public UpdateSchema moveAfter(String name, String afterName) {
        Integer fieldId = this.findForMove(name);
        Preconditions.checkArgument((fieldId != null ? 1 : 0) != 0, (String)"Cannot move missing column: %s", (Object)name);
        Integer afterId = this.findForMove(afterName);
        Preconditions.checkArgument((afterId != null ? 1 : 0) != 0, (String)"Cannot move %s after missing column: %s", (Object)name, (Object)afterName);
        Preconditions.checkArgument((!fieldId.equals(afterId) ? 1 : 0) != 0, (String)"Cannot move %s after itself", (Object)name);
        this.internalMove(name, Move.after(fieldId, afterId));
        return this;
    }

    public UpdateSchema unionByNameWith(Schema newSchema) {
        UnionByNameVisitor.visit(this, this.schema, newSchema, this.caseSensitive);
        return this;
    }

    public UpdateSchema setIdentifierFields(Collection<String> names) {
        this.identifierFieldNames = Sets.newHashSet(names);
        return this;
    }

    public UpdateSchema caseSensitive(boolean caseSensitivity) {
        this.caseSensitive = caseSensitivity;
        return this;
    }

    private boolean isAdded(String name) {
        return this.addedNameToId.containsKey(name);
    }

    private Types.NestedField findForUpdate(String name) {
        Types.NestedField existing = this.findField(name);
        if (existing != null) {
            Types.NestedField pendingUpdate = this.updates.get(existing.fieldId());
            if (pendingUpdate != null) {
                return pendingUpdate;
            }
            return existing;
        }
        Integer addedId = this.addedNameToId.get(name);
        if (addedId != null) {
            return this.updates.get(addedId);
        }
        return null;
    }

    private Integer findForMove(String name) {
        Integer addedId = this.addedNameToId.get(name);
        if (addedId != null) {
            return addedId;
        }
        Types.NestedField field = this.findField(name);
        if (field != null) {
            return field.fieldId();
        }
        return null;
    }

    private void internalMove(String name, Move move) {
        Integer parentId = this.idToParent.get(move.fieldId());
        if (parentId != null) {
            Types.NestedField parent = this.schema.findField(parentId.intValue());
            Preconditions.checkArgument((boolean)parent.type().isStructType(), (String)"Cannot move fields in non-struct type: %s", (Object)parent.type());
            if (move.type() == Move.MoveType.AFTER || move.type() == Move.MoveType.BEFORE) {
                Preconditions.checkArgument((boolean)parentId.equals(this.idToParent.get(move.referenceFieldId())), (String)"Cannot move field %s to a different struct", (Object)name);
            }
            this.moves.put((Object)parentId, (Object)move);
        } else {
            if (move.type() == Move.MoveType.AFTER || move.type() == Move.MoveType.BEFORE) {
                Preconditions.checkArgument((this.idToParent.get(move.referenceFieldId()) == null ? 1 : 0) != 0, (String)"Cannot move field %s to a different struct", (Object)name);
            }
            this.moves.put((Object)-1, (Object)move);
        }
    }

    public Schema apply() {
        return SchemaUpdate.applyChanges(this.schema, this.deletes, this.updates, this.parentToAddedIds, this.moves, this.identifierFieldNames, this.caseSensitive);
    }

    public void commit() {
        TableMetadata update = this.applyChangesToMetadata(this.base.updateSchema(this.apply()));
        this.ops.commit(this.base, update);
    }

    private int assignNewColumnId() {
        int next;
        this.lastColumnId = next = this.lastColumnId + 1;
        return next;
    }

    private TableMetadata applyChangesToMetadata(TableMetadata metadata) {
        String mappingJson = metadata.property("schema.name-mapping.default", null);
        TableMetadata newMetadata = metadata;
        if (mappingJson != null) {
            try {
                NameMapping mapping = NameMappingParser.fromJson(mappingJson);
                NameMapping updated = MappingUtil.update(mapping, this.updates, this.parentToAddedIds);
                HashMap updatedProperties = Maps.newHashMap();
                updatedProperties.putAll(metadata.properties());
                updatedProperties.put("schema.name-mapping.default", NameMappingParser.toJson(updated));
                newMetadata = metadata.replaceProperties(updatedProperties);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to update external schema mapping: {}", (Object)mappingJson, (Object)e);
            }
        }
        if (this.base != null && this.base.properties() != null) {
            Schema newSchema = newMetadata.schema();
            List<String> deletedColumns = this.deletes.stream().map(arg_0 -> ((Schema)this.schema).findColumnName(arg_0)).collect(Collectors.toList());
            Map<String, String> renamedColumns = this.updates.keySet().stream().filter(id -> !this.addedNameToId.containsValue(id)).filter(id -> !this.schema.findColumnName(id.intValue()).equals(newSchema.findColumnName(id.intValue()))).collect(Collectors.toMap(arg_0 -> ((Schema)this.schema).findColumnName(arg_0), arg_0 -> ((Schema)newSchema).findColumnName(arg_0)));
            if (!deletedColumns.isEmpty() || !renamedColumns.isEmpty()) {
                ImmutableSet columnProperties = ImmutableSet.of((Object)"write.metadata.metrics.column.", (Object)"write.parquet.bloom-filter-enabled.column.");
                Map<String, String> updatedProperties = PropertyUtil.applySchemaChanges(newMetadata.properties(), deletedColumns, renamedColumns, (Set<String>)columnProperties);
                newMetadata = newMetadata.replaceProperties(updatedProperties);
            }
        }
        return newMetadata;
    }

    private static Schema applyChanges(Schema schema, List<Integer> deletes, Map<Integer, Types.NestedField> updates, Multimap<Integer, Integer> parentToAddedIds, Multimap<Integer, Move> moves, Set<String> identifierFieldNames, boolean caseSensitive) {
        Map idToParent = TypeUtil.indexParents((Types.StructType)schema.asStruct());
        for (String name : identifierFieldNames) {
            Types.NestedField field = caseSensitive ? schema.findField(name) : schema.caseInsensitiveFindField(name);
            if (field == null) continue;
            Preconditions.checkArgument((!deletes.contains(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot delete identifier field %s. To force deletion, also call setIdentifierFields to update identifier fields.", (Object)field);
            Object parentId = (Integer)idToParent.get(field.fieldId());
            while (parentId != null) {
                Preconditions.checkArgument((!deletes.contains(parentId) ? 1 : 0) != 0, (String)"Cannot delete field %s as it will delete nested identifier field %s", (Object)schema.findField(((Integer)parentId).intValue()), (Object)field);
                parentId = (Integer)idToParent.get(parentId);
            }
        }
        Types.StructType struct = ((Type)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new ApplyChanges(deletes, updates, parentToAddedIds, moves))).asNestedType().asStructType();
        Map nameToId = TypeUtil.indexByName((Types.StructType)struct);
        HashSet freshIdentifierFieldIds = Sets.newHashSet();
        for (String name : identifierFieldNames) {
            Preconditions.checkArgument((boolean)nameToId.containsKey(name), (String)"Cannot add field %s as an identifier field: not found in current schema or added columns", (Object)name);
            freshIdentifierFieldIds.add((Integer)nameToId.get(name));
        }
        Map idToField = TypeUtil.indexById((Types.StructType)struct);
        freshIdentifierFieldIds.forEach(id -> Schema.validateIdentifierField((int)id, (Map)idToField, (Map)idToParent));
        return new Schema(struct.fields(), (Set)freshIdentifierFieldIds);
    }

    private static List<Types.NestedField> addAndMoveFields(List<Types.NestedField> fields, Collection<Types.NestedField> adds, Collection<Move> moves) {
        if (adds != null && !adds.isEmpty()) {
            if (moves != null && !moves.isEmpty()) {
                return SchemaUpdate.moveFields(SchemaUpdate.addFields(fields, adds), moves);
            }
            return SchemaUpdate.addFields(fields, adds);
        }
        if (moves != null && !moves.isEmpty()) {
            return SchemaUpdate.moveFields(fields, moves);
        }
        return null;
    }

    private static List<Types.NestedField> addFields(List<Types.NestedField> fields, Collection<Types.NestedField> adds) {
        ArrayList newFields = Lists.newArrayList(fields);
        newFields.addAll(adds);
        return newFields;
    }

    private static List<Types.NestedField> moveFields(List<Types.NestedField> fields, Collection<Move> moves) {
        LinkedList reordered = Lists.newLinkedList(fields);
        block5: for (Move move : moves) {
            Types.NestedField toMove = (Types.NestedField)Iterables.find((Iterable)reordered, field -> field.fieldId() == move.fieldId());
            reordered.remove(toMove);
            switch (move.type()) {
                case FIRST: {
                    reordered.addFirst(toMove);
                    continue block5;
                }
                case BEFORE: {
                    Types.NestedField before = (Types.NestedField)Iterables.find((Iterable)reordered, field -> field.fieldId() == move.referenceFieldId());
                    int beforeIndex = reordered.indexOf(before);
                    reordered.add(beforeIndex, toMove);
                    continue block5;
                }
                case AFTER: {
                    Types.NestedField after = (Types.NestedField)Iterables.find((Iterable)reordered, field -> field.fieldId() == move.referenceFieldId());
                    int afterIndex = reordered.indexOf(after);
                    reordered.add(afterIndex + 1, toMove);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown move type: " + move.type());
        }
        return reordered;
    }

    private Types.NestedField findField(String fieldName) {
        return this.caseSensitive ? this.schema.findField(fieldName) : this.schema.caseInsensitiveFindField(fieldName);
    }

    private static class Move {
        private final int fieldId;
        private final int referenceFieldId;
        private final MoveType type;

        public String toString() {
            Object suffix = "";
            if (this.type != MoveType.FIRST) {
                suffix = " field " + this.referenceFieldId;
            }
            return "Move column " + this.fieldId + " " + this.type.toString() + (String)suffix;
        }

        static Move first(int fieldId) {
            return new Move(fieldId, -1, MoveType.FIRST);
        }

        static Move before(int fieldId, int referenceFieldId) {
            return new Move(fieldId, referenceFieldId, MoveType.BEFORE);
        }

        static Move after(int fieldId, int referenceFieldId) {
            return new Move(fieldId, referenceFieldId, MoveType.AFTER);
        }

        private Move(int fieldId, int referenceFieldId, MoveType type) {
            this.fieldId = fieldId;
            this.referenceFieldId = referenceFieldId;
            this.type = type;
        }

        public int fieldId() {
            return this.fieldId;
        }

        public int referenceFieldId() {
            return this.referenceFieldId;
        }

        public MoveType type() {
            return this.type;
        }

        private static enum MoveType {
            FIRST,
            BEFORE,
            AFTER;

        }
    }

    private static class ApplyChanges
    extends TypeUtil.SchemaVisitor<Type> {
        private final List<Integer> deletes;
        private final Map<Integer, Types.NestedField> updates;
        private final Multimap<Integer, Integer> parentToAddedIds;
        private final Multimap<Integer, Move> moves;

        private ApplyChanges(List<Integer> deletes, Map<Integer, Types.NestedField> updates, Multimap<Integer, Integer> parentToAddedIds, Multimap<Integer, Move> moves) {
            this.deletes = deletes;
            this.updates = updates;
            this.parentToAddedIds = parentToAddedIds;
            this.moves = moves;
        }

        public Type schema(Schema schema, Type structResult) {
            List<Types.NestedField> addedFields = this.parentToAddedIds.get((Object)-1).stream().map(this.updates::get).collect(Collectors.toList());
            List<Types.NestedField> fields = SchemaUpdate.addAndMoveFields(structResult.asStructType().fields(), addedFields, this.moves.get((Object)-1));
            if (fields != null) {
                return Types.StructType.of(fields);
            }
            return structResult;
        }

        public Type struct(Types.StructType struct, List<Type> fieldResults) {
            boolean hasChange = false;
            ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fieldResults.size());
            for (int i = 0; i < fieldResults.size(); ++i) {
                Types.NestedField field;
                Type resultType = fieldResults.get(i);
                if (resultType == null) {
                    hasChange = true;
                    continue;
                }
                Types.NestedField update = this.updates.get((field = (Types.NestedField)struct.fields().get(i)).fieldId());
                Types.NestedField updated = Types.NestedField.from((Types.NestedField)(update != null ? update : field)).ofType(resultType).build();
                if (field.equals((Object)updated)) {
                    newFields.add(field);
                    continue;
                }
                hasChange = true;
                newFields.add(updated);
            }
            if (hasChange) {
                return Types.StructType.of((List)newFields);
            }
            return struct;
        }

        public Type field(Types.NestedField field, Type fieldResult) {
            List<Types.NestedField> fields;
            int fieldId = field.fieldId();
            if (this.deletes.contains(fieldId)) {
                return null;
            }
            Types.NestedField update = this.updates.get(field.fieldId());
            if (update != null && update.type() != field.type()) {
                return update.type();
            }
            Collection newFields = this.parentToAddedIds.get((Object)fieldId).stream().map(this.updates::get).collect(Collectors.toList());
            Collection columnsToMove = this.moves.get((Object)fieldId);
            if (!(newFields.isEmpty() && columnsToMove.isEmpty() || (fields = SchemaUpdate.addAndMoveFields(fieldResult.asStructType().fields(), newFields, columnsToMove)) == null)) {
                return Types.StructType.of(fields);
            }
            return fieldResult;
        }

        public Type list(Types.ListType list, Type elementResult) {
            boolean isElementOptional;
            Types.NestedField elementField = (Types.NestedField)list.fields().get(0);
            Type elementType = this.field(elementField, elementResult);
            if (elementType == null) {
                throw new IllegalArgumentException("Cannot delete element type from list: " + list);
            }
            Types.NestedField elementUpdate = this.updates.get(elementField.fieldId());
            boolean bl = isElementOptional = elementUpdate != null ? elementUpdate.isOptional() : list.isElementOptional();
            if (isElementOptional == elementField.isOptional() && list.elementType() == elementType) {
                return list;
            }
            if (isElementOptional) {
                return Types.ListType.ofOptional((int)list.elementId(), (Type)elementType);
            }
            return Types.ListType.ofRequired((int)list.elementId(), (Type)elementType);
        }

        public Type map(Types.MapType map, Type kResult, Type valueResult) {
            boolean isValueOptional;
            int keyId = ((Types.NestedField)map.fields().get(0)).fieldId();
            if (this.deletes.contains(keyId)) {
                throw new IllegalArgumentException("Cannot delete map keys: " + map);
            }
            if (this.updates.containsKey(keyId)) {
                throw new IllegalArgumentException("Cannot update map keys: " + map);
            }
            if (this.parentToAddedIds.containsKey((Object)keyId)) {
                throw new IllegalArgumentException("Cannot add fields to map keys: " + map);
            }
            if (!map.keyType().equals(kResult)) {
                throw new IllegalArgumentException("Cannot alter map keys: " + map);
            }
            Types.NestedField valueField = (Types.NestedField)map.fields().get(1);
            Type valueType = this.field(valueField, valueResult);
            if (valueType == null) {
                throw new IllegalArgumentException("Cannot delete value type from map: " + map);
            }
            Types.NestedField valueUpdate = this.updates.get(valueField.fieldId());
            boolean bl = isValueOptional = valueUpdate != null ? valueUpdate.isOptional() : map.isValueOptional();
            if (isValueOptional == map.isValueOptional() && map.valueType() == valueType) {
                return map;
            }
            if (isValueOptional) {
                return Types.MapType.ofOptional((int)map.keyId(), (int)map.valueId(), (Type)map.keyType(), (Type)valueType);
            }
            return Types.MapType.ofRequired((int)map.keyId(), (int)map.valueId(), (Type)map.keyType(), (Type)valueType);
        }

        public Type variant(Types.VariantType variant) {
            return variant;
        }

        public Type primitive(Type.PrimitiveType primitive) {
            return primitive;
        }
    }
}

