/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.apache.polaris.core.admin.model.AwsIamServiceIdentityInfo;

@ApiModel(description="Identity metadata for the Polaris service used to access external resources.")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="identityType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AwsIamServiceIdentityInfo.class, name="AWS_IAM")})
public class ServiceIdentityInfo {
    @NotNull
    private final IdentityTypeEnum identityType;

    @ApiModelProperty(required=true, value="The type of identity used to access external resources")
    @JsonProperty(value="identityType", required=true)
    public IdentityTypeEnum getIdentityType() {
        return this.identityType;
    }

    @JsonCreator
    public ServiceIdentityInfo(@JsonProperty(value="identityType", required=true) IdentityTypeEnum identityType) {
        this.identityType = identityType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceIdentityInfo serviceIdentityInfo = (ServiceIdentityInfo)o;
        return Objects.equals((Object)this.identityType, (Object)serviceIdentityInfo.identityType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identityType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceIdentityInfo {\n");
        sb.append("    identityType: ").append(this.toIndentedString((Object)this.identityType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IdentityTypeEnum {
        AWS_IAM("AWS_IAM");

        private String value;

        private IdentityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class Builder {
        private IdentityTypeEnum identityType;

        private Builder() {
        }

        private Builder(IdentityTypeEnum identityType) {
            this.identityType = identityType;
        }

        public Builder setIdentityType(IdentityTypeEnum identityType) {
            this.identityType = identityType;
            return this;
        }

        public ServiceIdentityInfo build() {
            ServiceIdentityInfo inst = new ServiceIdentityInfo(this.identityType);
            return inst;
        }
    }
}

