/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.admintool.config;

import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nullable;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import java.lang.annotation.Annotation;
import java.time.Clock;
import org.apache.polaris.core.PolarisDefaultDiagServiceImpl;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class QuarkusProducers {
    @Produces
    public MetaStoreManagerFactory metaStoreManagerFactory(@ConfigProperty(name="polaris.persistence.type") String persistenceType, @Any Instance<MetaStoreManagerFactory> metaStoreManagerFactories) {
        return (MetaStoreManagerFactory)metaStoreManagerFactories.select(new Annotation[]{Identifier.Literal.of((String)persistenceType)}).get();
    }

    @Produces
    @ApplicationScoped
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Produces
    @ApplicationScoped
    public PolarisDiagnostics polarisDiagnostics() {
        return new PolarisDefaultDiagServiceImpl();
    }

    @Produces
    public PolarisStorageIntegrationProvider storageIntegrationProvider() {
        return new PolarisStorageIntegrationProvider(this){

            @Nullable
            public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> getStorageIntegrationForConfig(PolarisStorageConfigurationInfo polarisStorageConfigurationInfo) {
                return null;
            }
        };
    }

    @Produces
    public PolarisConfigurationStore configurationStore() {
        return new PolarisConfigurationStore(this){};
    }
}

