/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.api;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;
import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.api.PolarisCatalogGenericTableApiService;
import org.apache.polaris.service.types.CreateGenericTableRequest;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/catalog/polaris/v1/{prefix}/namespaces/{namespace}/generic-tables")
public class PolarisCatalogGenericTableApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCatalogGenericTableApi.class);
    private final PolarisCatalogGenericTableApiService service;

    @Inject
    public PolarisCatalogGenericTableApi(PolarisCatalogGenericTableApiService service) {
        this.service = service;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.GenericTableApi.createGenericTable")
    @Timeout
    public Response createGenericTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Nonnull @Valid CreateGenericTableRequest createGenericTableRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking GenericTableApi with params").addKeyValue("operation", (Object)"createGenericTable").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("createGenericTableRequest", (Object)String.valueOf(createGenericTableRequest)).log();
        Response ret = this.service.createGenericTable(prefix, namespace, createGenericTableRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of createGenericTable API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/{generic-table}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.GenericTableApi.dropGenericTable")
    @Timeout
    public Response dropGenericTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="generic-table") String genericTable, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking GenericTableApi with params").addKeyValue("operation", (Object)"dropGenericTable").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("genericTable", (Object)genericTable).log();
        Response ret = this.service.dropGenericTable(prefix, namespace, genericTable, realmContext, securityContext);
        LOGGER.debug("Completed execution of dropGenericTable API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.GenericTableApi.listGenericTables")
    @Timeout
    public Response listGenericTables(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") @Min(value=1L) @Min(value=1L) Integer pageSize, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking GenericTableApi with params").addKeyValue("operation", (Object)"listGenericTables").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("pageToken", (Object)pageToken).addKeyValue("pageSize", (Object)pageSize).log();
        Response ret = this.service.listGenericTables(prefix, namespace, pageToken, pageSize, realmContext, securityContext);
        LOGGER.debug("Completed execution of listGenericTables API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{generic-table}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.GenericTableApi.loadGenericTable")
    @Timeout
    public Response loadGenericTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="generic-table") String genericTable, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking GenericTableApi with params").addKeyValue("operation", (Object)"loadGenericTable").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("genericTable", (Object)genericTable).log();
        Response ret = this.service.loadGenericTable(prefix, namespace, genericTable, realmContext, securityContext);
        LOGGER.debug("Completed execution of loadGenericTable API with status code {}", (Object)ret.getStatus());
        return ret;
    }
}

