/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import jakarta.annotation.Nonnull;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.StorageAccessProperty;

public abstract class PolarisStorageIntegration<T extends PolarisStorageConfigurationInfo> {
    private final String integrationIdentifierOrId;

    public PolarisStorageIntegration(String identifierOrId) {
        this.integrationIdentifierOrId = identifierOrId;
    }

    public String getStorageIdentifierOrId() {
        return this.integrationIdentifierOrId;
    }

    public abstract EnumMap<StorageAccessProperty, String> getSubscopedCreds(@Nonnull PolarisDiagnostics var1, @Nonnull T var2, boolean var3, @Nonnull Set<String> var4, @Nonnull Set<String> var5);

    @Nonnull
    public abstract Map<String, Map<PolarisStorageActions, ValidationResult>> validateAccessToLocations(@Nonnull T var1, @Nonnull Set<PolarisStorageActions> var2, @Nonnull Set<String> var3);

    public static final class ValidationResult {
        private final boolean success;
        private final String message;

        public ValidationResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValidationResult)) {
                return false;
            }
            ValidationResult that = (ValidationResult)o;
            return this.success == that.success;
        }

        public int hashCode() {
            return Boolean.hashCode(this.success);
        }

        public String toString() {
            return "ValidationResult{success=" + this.success + ", message='" + this.message + "'}";
        }
    }
}

