/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.StorageConfigInfo;

@ApiModel(description="gcp storage configuration info")
public class GcpStorageConfigInfo
extends StorageConfigInfo {
    private final String gcsServiceAccount;

    @ApiModelProperty(value="a Google cloud storage service account")
    @JsonProperty(value="gcsServiceAccount")
    public String getGcsServiceAccount() {
        return this.gcsServiceAccount;
    }

    @JsonCreator
    public GcpStorageConfigInfo(@JsonProperty(value="gcsServiceAccount") String gcsServiceAccount, @JsonProperty(value="storageType", required=true) StorageConfigInfo.StorageTypeEnum storageType, @JsonProperty(value="allowedLocations") List<String> allowedLocations) {
        super(storageType, allowedLocations);
        this.gcsServiceAccount = gcsServiceAccount;
    }

    public GcpStorageConfigInfo(StorageConfigInfo.StorageTypeEnum storageType) {
        super(storageType);
        this.gcsServiceAccount = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StorageConfigInfo.StorageTypeEnum storageType) {
        return new Builder(storageType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GcpStorageConfigInfo gcpStorageConfigInfo = (GcpStorageConfigInfo)o;
        return super.equals(o) && Objects.equals(this.gcsServiceAccount, gcpStorageConfigInfo.gcsServiceAccount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.gcsServiceAccount);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GcpStorageConfigInfo {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    gcsServiceAccount: ").append(this.toIndentedString(this.gcsServiceAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String gcsServiceAccount;
        private StorageConfigInfo.StorageTypeEnum storageType;
        private List<String> allowedLocations;

        private Builder() {
        }

        private Builder(StorageConfigInfo.StorageTypeEnum storageType) {
            this.storageType = storageType;
        }

        public Builder setGcsServiceAccount(String gcsServiceAccount) {
            this.gcsServiceAccount = gcsServiceAccount;
            return this;
        }

        public Builder setStorageType(StorageConfigInfo.StorageTypeEnum storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder setAllowedLocations(List<String> allowedLocations) {
            this.allowedLocations = allowedLocations;
            return this;
        }

        public GcpStorageConfigInfo build() {
            GcpStorageConfigInfo inst = new GcpStorageConfigInfo(this.gcsServiceAccount, this.storageType, this.allowedLocations);
            return inst;
        }
    }
}

