/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation;

import com.azure.storage.internal.avro.implementation.AvroObject;
import com.azure.storage.internal.avro.implementation.AvroSyncParser;
import com.azure.storage.internal.avro.implementation.AvroSyncReader;
import java.nio.ByteBuffer;

public class AvroReaderSyncFactory {
    public AvroSyncReader getAvroReader(ByteBuffer avroHeader, ByteBuffer avroBody, long offset, long thresholdIndex) {
        AvroSyncParser parser = new AvroSyncParser(true);
        return new InternalAvroSyncReader(parser, avroHeader, avroBody, offset, thresholdIndex);
    }

    public AvroSyncReader getAvroReader(ByteBuffer data) {
        AvroSyncParser parser = new AvroSyncParser(false);
        return () -> parser.parse(data);
    }

    private static class InternalAvroSyncReader
    implements AvroSyncReader {
        private final AvroSyncParser parser;
        private final ByteBuffer avroHeader;
        private final ByteBuffer avroBody;
        private final long offset;
        private final long thresholdIndex;

        InternalAvroSyncReader(AvroSyncParser parser, ByteBuffer avroHeader, ByteBuffer avroBody, long offset, long thresholdIndex) {
            this.parser = parser;
            this.avroHeader = avroHeader;
            this.avroBody = avroBody;
            this.offset = offset;
            this.thresholdIndex = thresholdIndex;
        }

        @Override
        public Iterable<AvroObject> read() {
            this.avroHeader.position(0);
            this.parser.parse(this.avroHeader);
            this.parser.prepareParserToReadBody(this.offset, this.thresholdIndex);
            this.avroBody.position((int)this.offset);
            return this.parser.parse(this.avroBody);
        }
    }
}

