/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.AuthenticationFailedException;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTokenStateManager
implements TokenStateManager {
    private static final Logger LOG = Logger.getLogger(DefaultTokenStateManager.class);

    @Override
    public Uni<String> createTokenState(RoutingContext routingContext, OidcTenantConfig oidcConfig, AuthorizationCodeTokens tokens, OidcRequestContext<String> requestContext) {
        if (!oidcConfig.tokenStateManager().splitTokens()) {
            StringBuilder sb = new StringBuilder();
            sb.append(tokens.getIdToken());
            if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
                sb.append("|").append(tokens.getAccessToken()).append("|").append(tokens.getAccessTokenExpiresIn() != null ? tokens.getAccessTokenExpiresIn() : "").append("|").append(tokens.getRefreshToken());
            } else if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS) {
                sb.append("|").append("").append("|").append("").append("|").append(tokens.getRefreshToken());
            }
            String encryptedTokens = this.encryptToken(sb.toString(), routingContext, oidcConfig);
            return Uni.createFrom().item((Object)encryptedTokens);
        }
        String encryptedIdToken = this.encryptToken(tokens.getIdToken(), routingContext, oidcConfig);
        if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            StringBuilder sb = new StringBuilder();
            sb.append(tokens.getAccessToken()).append("|").append(tokens.getAccessTokenExpiresIn() != null ? tokens.getAccessTokenExpiresIn() : "");
            CodeAuthenticationMechanism.createCookie(routingContext, oidcConfig, DefaultTokenStateManager.getAccessTokenCookieName(oidcConfig), this.encryptToken(sb.toString(), routingContext, oidcConfig), (Long)routingContext.get("session-max-age"), true);
            if (tokens.getRefreshToken() != null) {
                CodeAuthenticationMechanism.createCookie(routingContext, oidcConfig, DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig), this.encryptToken(tokens.getRefreshToken(), routingContext, oidcConfig), (Long)routingContext.get("session-max-age"), true);
            }
        } else if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS && tokens.getRefreshToken() != null) {
            CodeAuthenticationMechanism.createCookie(routingContext, oidcConfig, DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig), this.encryptToken(tokens.getRefreshToken(), routingContext, oidcConfig), (Long)routingContext.get("session-max-age"));
        }
        return Uni.createFrom().item((Object)encryptedIdToken);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Uni<AuthorizationCodeTokens> getTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<AuthorizationCodeTokens> requestContext) {
        ServerCookie rtCookie;
        String idToken = null;
        String accessToken = null;
        Long accessTokenExpiresIn = null;
        String refreshToken = null;
        if (!oidcConfig.tokenStateManager().splitTokens()) {
            String decryptedTokenState = this.decryptToken(tokenState, routingContext, oidcConfig);
            String[] tokens = CodeAuthenticationMechanism.COOKIE_PATTERN.split(decryptedTokenState);
            try {
                idToken = tokens[0];
                accessToken = null;
                refreshToken = null;
                if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
                    accessToken = tokens[1];
                    accessTokenExpiresIn = tokens[2].isEmpty() ? null : DefaultTokenStateManager.parseAccessTokenExpiresIn(tokens[2]);
                    refreshToken = tokens[3];
                    return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn));
                }
                if (oidcConfig.tokenStateManager().strategy() != OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS) return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn));
                refreshToken = tokens[3];
                return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn));
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                String error = "Session cookie is malformed";
                LOG.debug((Object)ex);
                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Session cookie is malformed"));
            }
            catch (AuthenticationFailedException ex) {
                return Uni.createFrom().failure((Throwable)ex);
            }
        }
        idToken = this.decryptToken(tokenState, routingContext, oidcConfig);
        accessToken = null;
        refreshToken = null;
        if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            ServerCookie rtCookie2;
            ServerCookie atCookie = DefaultTokenStateManager.getAccessTokenCookie(routingContext, oidcConfig);
            if (atCookie != null) {
                String accessTokenState = this.decryptToken(atCookie.getValue(), routingContext, oidcConfig);
                String[] accessTokenData = CodeAuthenticationMechanism.COOKIE_PATTERN.split(accessTokenState);
                accessToken = accessTokenData[0];
                try {
                    accessTokenExpiresIn = accessTokenData[1].isEmpty() ? null : DefaultTokenStateManager.parseAccessTokenExpiresIn(accessTokenData[1]);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    String error = "Session cookie is malformed";
                    LOG.debug((Object)ex);
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Session cookie is malformed"));
                }
                catch (AuthenticationFailedException ex) {
                    return Uni.createFrom().failure((Throwable)ex);
                }
            }
            if ((rtCookie2 = DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig)) == null) return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn));
            refreshToken = this.decryptToken(rtCookie2.getValue(), routingContext, oidcConfig);
            return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn));
        }
        if (oidcConfig.tokenStateManager().strategy() != OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS || (rtCookie = DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig)) == null) return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn));
        refreshToken = this.decryptToken(rtCookie.getValue(), routingContext, oidcConfig);
        return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn));
    }

    @Override
    public Uni<Void> deleteTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<Void> requestContext) {
        if (oidcConfig.tokenStateManager().splitTokens()) {
            OidcUtils.removeCookie(routingContext, DefaultTokenStateManager.getAccessTokenCookie(routingContext, oidcConfig), oidcConfig);
            OidcUtils.removeCookie(routingContext, DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig), oidcConfig);
        }
        return CodeAuthenticationMechanism.VOID_UNI;
    }

    private static Long parseAccessTokenExpiresIn(String accessTokenExpiresInString) {
        try {
            return Long.valueOf(accessTokenExpiresInString);
        }
        catch (NumberFormatException ex) {
            String error = "Access token expires_in property in the session cookie must be a number, found %s\n".formatted(accessTokenExpiresInString);
            LOG.debug((Object)ex);
            throw new AuthenticationFailedException(error);
        }
    }

    private static ServerCookie getAccessTokenCookie(RoutingContext routingContext, OidcTenantConfig oidcConfig) {
        return (ServerCookie)routingContext.request().getCookie(DefaultTokenStateManager.getAccessTokenCookieName(oidcConfig));
    }

    private static ServerCookie getRefreshTokenCookie(RoutingContext routingContext, OidcTenantConfig oidcConfig) {
        return (ServerCookie)routingContext.request().getCookie(DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig));
    }

    private static String getAccessTokenCookieName(OidcTenantConfig oidcConfig) {
        String cookieSuffix = OidcUtils.getCookieSuffix(oidcConfig);
        return "q_session_at" + cookieSuffix;
    }

    private static String getRefreshTokenCookieName(OidcTenantConfig oidcConfig) {
        String cookieSuffix = OidcUtils.getCookieSuffix(oidcConfig);
        return "q_session_rt" + cookieSuffix;
    }

    private String encryptToken(String token, RoutingContext context, OidcTenantConfig oidcConfig) {
        if (oidcConfig.tokenStateManager().encryptionRequired()) {
            TenantConfigContext configContext = (TenantConfigContext)context.get(TenantConfigContext.class.getName());
            try {
                KeyEncryptionAlgorithm encAlgorithm = KeyEncryptionAlgorithm.valueOf((String)oidcConfig.tokenStateManager().encryptionAlgorithm().name());
                return OidcUtils.encryptString(token, configContext.getTokenEncSecretKey(), encAlgorithm);
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException((Throwable)ex);
            }
        }
        return token;
    }

    private String decryptToken(String token, RoutingContext context, OidcTenantConfig oidcConfig) {
        if (oidcConfig.tokenStateManager().encryptionRequired()) {
            TenantConfigContext configContext = (TenantConfigContext)context.get(TenantConfigContext.class.getName());
            try {
                KeyEncryptionAlgorithm encAlgorithm = KeyEncryptionAlgorithm.valueOf((String)oidcConfig.tokenStateManager().encryptionAlgorithm().name());
                return OidcUtils.decryptString(token, configContext.getTokenEncSecretKey(), encAlgorithm);
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException((Throwable)ex);
            }
        }
        return token;
    }
}

