/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.locale;

import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Locale;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolverContext;

@Singleton
@Named(value="locale-resolver-wrapper")
public class LocaleResolversWrapper
implements LocaleResolver {
    @Inject
    Instance<LocaleResolver> resolvers;

    public Locale resolve(LocaleResolverContext context) {
        for (LocaleResolver resolver : this.resolvers) {
            Locale locale;
            if (resolver.equals(this) || (locale = resolver.resolve(context)) == null) continue;
            return locale;
        }
        return context.getDefaultLocale();
    }
}

