/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.polaris.core.auth.AuthenticatedPolarisPrincipal;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.service.auth.Authenticator;
import org.apache.polaris.service.auth.PrincipalAuthInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Identifier(value="default")
public class DefaultAuthenticator
implements Authenticator<PrincipalAuthInfo, AuthenticatedPolarisPrincipal> {
    public static final String PRINCIPAL_ROLE_ALL = "PRINCIPAL_ROLE:ALL";
    public static final String PRINCIPAL_ROLE_PREFIX = "PRINCIPAL_ROLE:";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticator.class);
    @Inject
    MetaStoreManagerFactory metaStoreManagerFactory;
    @Inject
    CallContext callContext;

    @Override
    public Optional<AuthenticatedPolarisPrincipal> authenticate(PrincipalAuthInfo credentials) {
        LOGGER.debug("Resolving principal for credentials={}", (Object)credentials);
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerFactory.getOrCreateMetaStoreManager(this.callContext.getRealmContext());
        PolarisEntity principal = null;
        try {
            if (credentials.getPrincipalId() != null && credentials.getPrincipalId() > 0L) {
                principal = PolarisEntity.of((EntityResult)metaStoreManager.loadEntity(this.callContext.getPolarisCallContext(), 0L, credentials.getPrincipalId().longValue(), PolarisEntityType.PRINCIPAL));
            } else if (credentials.getPrincipalName() != null) {
                principal = PolarisEntity.of((EntityResult)metaStoreManager.readEntityByName(this.callContext.getPolarisCallContext(), null, PolarisEntityType.PRINCIPAL, PolarisEntitySubType.NULL_SUBTYPE, credentials.getPrincipalName()));
            }
        }
        catch (Exception e) {
            LOGGER.atError().addKeyValue("errMsg", (Object)e.getMessage()).addKeyValue("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)e)).log("Unable to authenticate user with token");
            throw new ServiceFailureException("Unable to fetch principal entity", new Object[0]);
        }
        if (principal == null || principal.getType() != PolarisEntityType.PRINCIPAL) {
            LOGGER.warn("Failed to resolve principal from credentials={}", (Object)credentials);
            throw new NotAuthorizedException("Unable to authenticate", new Object[0]);
        }
        LOGGER.debug("Resolved principal: {}", principal);
        boolean allRoles = credentials.getPrincipalRoles().contains(PRINCIPAL_ROLE_ALL);
        HashSet<String> activatedPrincipalRoles = new HashSet<String>();
        if (!allRoles) {
            activatedPrincipalRoles.addAll(credentials.getPrincipalRoles().stream().filter(s -> s.startsWith(PRINCIPAL_ROLE_PREFIX)).map(s -> s.substring(PRINCIPAL_ROLE_PREFIX.length())).toList());
        }
        LOGGER.debug("Resolved principal: {}", (Object)principal);
        AuthenticatedPolarisPrincipal authenticatedPrincipal = new AuthenticatedPolarisPrincipal((PolarisEntity)new PrincipalEntity((PolarisBaseEntity)principal), activatedPrincipalRoles);
        return Optional.of(authenticatedPrincipal);
    }
}

