/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.PolicyPrivilege;

public class PolicyGrant
extends GrantResource {
    @NotNull
    private final List<String> namespace;
    @NotNull
    private final String policyName;
    @NotNull
    @Valid
    private final PolicyPrivilege privilege;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="namespace", required=true)
    public List<String> getNamespace() {
        return this.namespace;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="policyName", required=true)
    public String getPolicyName() {
        return this.policyName;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="privilege", required=true)
    public PolicyPrivilege getPrivilege() {
        return this.privilege;
    }

    @JsonCreator
    public PolicyGrant(@JsonProperty(value="namespace", required=true) List<String> namespace, @JsonProperty(value="policyName", required=true) String policyName, @JsonProperty(value="privilege", required=true) PolicyPrivilege privilege, @JsonProperty(value="type", required=true) GrantResource.TypeEnum type) {
        super(type);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
        this.policyName = policyName;
        this.privilege = privilege;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(List<String> namespace, String policyName, PolicyPrivilege privilege, GrantResource.TypeEnum type) {
        return new Builder(namespace, policyName, privilege, type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyGrant policyGrant = (PolicyGrant)o;
        return super.equals(o) && Objects.equals(this.namespace, policyGrant.namespace) && Objects.equals(this.policyName, policyGrant.policyName) && Objects.equals((Object)this.privilege, (Object)policyGrant.privilege);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.namespace, super.hashCode(), this.policyName, super.hashCode(), this.privilege});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyGrant {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    policyName: ").append(this.toIndentedString(this.policyName)).append("\n");
        sb.append("    privilege: ").append(this.toIndentedString((Object)this.privilege)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private List<String> namespace;
        private String policyName;
        private PolicyPrivilege privilege;
        private GrantResource.TypeEnum type;

        private Builder() {
        }

        private Builder(List<String> namespace, String policyName, PolicyPrivilege privilege, GrantResource.TypeEnum type) {
            this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
            this.policyName = policyName;
            this.privilege = privilege;
            this.type = type;
        }

        public Builder setNamespace(List<String> namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setPolicyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public Builder setPrivilege(PolicyPrivilege privilege) {
            this.privilege = privilege;
            return this;
        }

        public Builder setType(GrantResource.TypeEnum type) {
            this.type = type;
            return this;
        }

        public PolicyGrant build() {
            PolicyGrant inst = new PolicyGrant(this.namespace, this.policyName, this.privilege, this.type);
            return inst;
        }
    }
}

