/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine;

import com.google.protobuf.ByteString;
import io.micrometer.core.instrument.Tags;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basekv.localengine.IKVSpace;
import org.apache.bifromq.basekv.localengine.IKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.KVSpaceDescriptor;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.proto.Boundary;
import org.slf4j.Logger;

public abstract class AbstractKVSpace<P extends IKVSpaceEpoch>
implements IKVSpace {
    protected final String id;
    protected final KVSpaceOpMeters opMeters;
    protected final Logger logger;
    protected final Tags tags;
    private final AtomicReference<State> state;
    private final Runnable onDestroy;
    private final BehaviorSubject<Map<ByteString, ByteString>> metadataSubject;

    public AbstractKVSpace(String id, Runnable onDestroy, KVSpaceOpMeters opMeters, Logger logger, String ... tags) {
        this.id = id;
        this.opMeters = opMeters;
        this.logger = logger;
        this.onDestroy = onDestroy;
        this.state = new AtomicReference<State>(State.Init);
        this.metadataSubject = BehaviorSubject.createDefault(Collections.emptyMap());
        this.tags = Tags.of((String[])tags).and("spaceId", id);
    }

    @Override
    public final String id() {
        return this.id;
    }

    @Override
    public final void open() {
        if (this.state.compareAndSet(State.Init, State.Opening)) {
            this.doOpen();
        }
    }

    @Override
    public final Observable<Map<ByteString, ByteString>> metadata() {
        return this.metadataSubject;
    }

    @Override
    public final KVSpaceDescriptor describe() {
        return new KVSpaceDescriptor(this.id, this.collectStats());
    }

    @Override
    public final long size() {
        return this.opMeters.sizeCallTimer.record(() -> this.doSize(Boundary.getDefaultInstance()));
    }

    @Override
    public final void destroy() {
        this.close();
        if (this.state.compareAndSet(State.Closed, State.Destroying)) {
            try {
                this.doDestroy();
            }
            catch (Throwable e) {
                throw new KVEngineException("Destroy KVRange error", e);
            }
            finally {
                this.onDestroy.run();
                this.state.set(State.Terminated);
            }
        }
    }

    @Override
    public final void close() {
        if (this.state.compareAndSet(State.Opening, State.Closing)) {
            try {
                this.doClose();
                this.metadataSubject.onComplete();
            }
            finally {
                this.state.set(State.Closed);
            }
        }
    }

    protected Map<ByteString, ByteString> currentMetadata() {
        return (Map)this.metadataSubject.getValue();
    }

    protected void updateMetadata(Map<ByteString, ByteString> newMetadata) {
        this.metadataSubject.onNext(newMetadata);
    }

    protected final State state() {
        return this.state.get();
    }

    protected abstract void doClose();

    protected void doDestroy() {
    }

    protected abstract P handle();

    protected abstract void doOpen();

    protected abstract long doSize(Boundary var1);

    private Map<String, Double> collectStats() {
        HashMap<String, Double> stats = new HashMap<String, Double>();
        stats.put("size", Double.valueOf(this.size()));
        return stats;
    }

    protected static enum State {
        Init,
        Opening,
        Destroying,
        Closing,
        Closed,
        Terminated;

    }
}

