/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.formats.paimon;

import java.util.Map;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.TableSnapshot;
import org.apache.amoro.formats.paimon.PaimonSnapshot;
import org.apache.amoro.table.TableIdentifier;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.Table;

public class PaimonTable
implements AmoroTable<Table> {
    private final TableIdentifier tableIdentifier;
    private final Table table;

    public PaimonTable(TableIdentifier tableIdentifier, Table table) {
        this.tableIdentifier = tableIdentifier;
        this.table = table;
    }

    @Override
    public TableIdentifier id() {
        return this.tableIdentifier;
    }

    @Override
    public TableFormat format() {
        return TableFormat.PAIMON;
    }

    @Override
    public Map<String, String> properties() {
        return this.table.options();
    }

    @Override
    public Table originalTable() {
        return this.table;
    }

    @Override
    public TableSnapshot currentSnapshot() {
        if (!(this.table instanceof DataTable)) {
            return null;
        }
        Snapshot snapshot = ((DataTable)this.table).snapshotManager().latestSnapshot();
        return snapshot == null ? null : new PaimonSnapshot(snapshot);
    }
}

