/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.client;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.amoro.api.OptimizingService;
import org.apache.amoro.client.PoolConfig;
import org.apache.amoro.client.ThriftClientPool;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.amoro.shade.thrift.org.apache.thrift.protocol.TProtocol;

public class OptimizingClientPools {
    private static final int CLIENT_POOL_MIN_IDLE = 1;
    private static final int CLIENT_POOL_MAX_IDLE = 5;
    private static final LoadingCache<String, ThriftClientPool<OptimizingService.Client>> CLIENT_POOLS = Caffeine.newBuilder().build(OptimizingClientPools::buildClient);

    public static OptimizingService.Iface getClient(String metastoreUrl) {
        return (OptimizingService.Iface)((ThriftClientPool)CLIENT_POOLS.get((Object)metastoreUrl)).iface();
    }

    private static ThriftClientPool<OptimizingService.Client> buildClient(String url) {
        PoolConfig poolConfig = new PoolConfig();
        poolConfig.setFailover(true);
        poolConfig.setMinIdle(1);
        poolConfig.setMaxIdle(5);
        poolConfig.setMaxTotal(-1);
        return new ThriftClientPool<OptimizingService.Client>(url, s -> new OptimizingService.Client((TProtocol)new TMultiplexedProtocol((TProtocol)new TBinaryProtocol(s), "OptimizeManager")), c -> {
            try {
                ((OptimizingService.Client)c).ping();
            }
            catch (TException e) {
                return false;
            }
            return true;
        }, poolConfig, "OptimizeManager");
    }
}

