/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.model;

import java.util.List;
import java.util.Map;
import org.apache.amoro.server.dashboard.model.FilesStatistics;
import org.apache.amoro.server.optimizing.MetricsSummary;
import org.apache.amoro.server.optimizing.OptimizingProcess;
import org.apache.amoro.server.optimizing.OptimizingProcessMeta;
import org.apache.amoro.server.optimizing.OptimizingTaskMeta;
import org.apache.amoro.server.optimizing.OptimizingType;

public class OptimizingProcessInfo {
    private Long tableId;
    private String catalogName;
    private String dbName;
    private String tableName;
    private Long processId;
    private long startTime;
    private OptimizingType optimizingType;
    private OptimizingProcess.Status status;
    private String failReason;
    private long duration;
    private int successTasks;
    private int totalTasks;
    private int runningTasks;
    private long finishTime;
    private FilesStatistics inputFiles;
    private FilesStatistics outputFiles;
    private Map<String, String> summary;

    public Long getTableId() {
        return this.tableId;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public OptimizingType getOptimizingType() {
        return this.optimizingType;
    }

    public void setOptimizingType(OptimizingType optimizingType) {
        this.optimizingType = optimizingType;
    }

    public OptimizingProcess.Status getStatus() {
        return this.status;
    }

    public void setStatus(OptimizingProcess.Status status) {
        this.status = status;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public int getSuccessTasks() {
        return this.successTasks;
    }

    public void setSuccessTasks(int successTasks) {
        this.successTasks = successTasks;
    }

    public int getTotalTasks() {
        return this.totalTasks;
    }

    public void setTotalTasks(int totalTasks) {
        this.totalTasks = totalTasks;
    }

    public int getRunningTasks() {
        return this.runningTasks;
    }

    public void setRunningTasks(int runningTasks) {
        this.runningTasks = runningTasks;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public FilesStatistics getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(FilesStatistics inputFiles) {
        this.inputFiles = inputFiles;
    }

    public FilesStatistics getOutputFiles() {
        return this.outputFiles;
    }

    public void setOutputFiles(FilesStatistics outputFiles) {
        this.outputFiles = outputFiles;
    }

    public Map<String, String> getSummary() {
        return this.summary;
    }

    public void setSummary(Map<String, String> summary) {
        this.summary = summary;
    }

    public static OptimizingProcessInfo build(OptimizingProcessMeta meta, List<OptimizingTaskMeta> optimizingTaskStats) {
        MetricsSummary summary;
        if (meta == null) {
            return null;
        }
        OptimizingProcessInfo result = new OptimizingProcessInfo();
        if (optimizingTaskStats != null) {
            int successTasks = 0;
            int runningTasks = 0;
            for (OptimizingTaskMeta optimizingTaskStat : optimizingTaskStats) {
                switch (optimizingTaskStat.getStatus()) {
                    case SUCCESS: {
                        ++successTasks;
                        break;
                    }
                    case SCHEDULED: 
                    case ACKED: {
                        ++runningTasks;
                    }
                }
            }
            result.setTotalTasks(optimizingTaskStats.size());
            result.setSuccessTasks(successTasks);
            result.setRunningTasks(runningTasks);
        }
        if ((summary = meta.getSummary()) != null) {
            result.setInputFiles(summary.getInputFilesStatistics());
            result.setOutputFiles(summary.getOutputFilesStatistics());
        }
        result.setTableId(meta.getTableId());
        result.setCatalogName(meta.getCatalogName());
        result.setDbName(meta.getDbName());
        result.setTableName(meta.getTableName());
        result.setProcessId(meta.getProcessId());
        result.setStartTime(meta.getPlanTime());
        result.setOptimizingType(meta.getOptimizingType());
        result.setStatus(meta.getStatus());
        result.setFailReason(meta.getFailReason());
        result.setDuration(meta.getEndTime() > 0L ? meta.getEndTime() - meta.getPlanTime() : System.currentTimeMillis() - meta.getPlanTime());
        result.setFinishTime(meta.getEndTime());
        result.setSummary(meta.getSummary().summaryAsMap(true));
        return result;
    }
}

