/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import java.util.Map;
import java.util.Set;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.catalog.ExternalCatalog;
import org.apache.amoro.server.catalog.InternalIcebergCatalogImpl;
import org.apache.amoro.server.catalog.InternalMixedCatalogImpl;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.utils.MixedCatalogUtil;

public class CatalogBuilder {
    private static final Map<String, Set<TableFormat>> formatSupportedMatrix = ImmutableMap.of((Object)"hadoop", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG, TableFormat.PAIMON}), (Object)"glue", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG}), (Object)"custom", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG}), (Object)"hive", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG, TableFormat.MIXED_HIVE, TableFormat.PAIMON}), (Object)"ams", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG}));

    private static String getAmsURI(Configurations serviceConfig) {
        String host = serviceConfig.getString(AmoroManagementConf.SERVER_EXPOSE_HOST);
        Integer port = serviceConfig.getInteger(AmoroManagementConf.TABLE_SERVICE_THRIFT_BIND_PORT);
        return String.format("thrift://%s:%d", host, port);
    }

    public static ServerCatalog buildServerCatalog(CatalogMeta catalogMeta, Configurations serverConfiguration) {
        String type = catalogMeta.getCatalogType();
        Set tableFormats = MixedCatalogUtil.tableFormats((CatalogMeta)catalogMeta);
        Preconditions.checkState((boolean)formatSupportedMatrix.containsKey(type), (String)"unsupported catalog type: %s", (Object)type);
        Set<TableFormat> supportedFormats = formatSupportedMatrix.get(type);
        TableFormat tableFormat = (TableFormat)tableFormats.iterator().next();
        Preconditions.checkState((boolean)supportedFormats.contains(tableFormat), (String)"Table format %s is not supported for metastore type: %s", (Object)tableFormat, (Object)type);
        switch (type) {
            case "hadoop": 
            case "glue": 
            case "custom": {
                return new ExternalCatalog(catalogMeta);
            }
            case "hive": {
                String amsUri = CatalogBuilder.getAmsURI(serverConfiguration);
                catalogMeta.getCatalogProperties().put("ams.uri", amsUri);
                return new ExternalCatalog(catalogMeta);
            }
            case "ams": {
                if (tableFormat.equals((Object)TableFormat.MIXED_ICEBERG)) {
                    return new InternalMixedCatalogImpl(catalogMeta, serverConfiguration);
                }
                if (tableFormat.equals((Object)TableFormat.ICEBERG)) {
                    return new InternalIcebergCatalogImpl(catalogMeta, serverConfiguration);
                }
                throw new IllegalStateException("AMS catalog support iceberg/mixed-iceberg table only.");
            }
        }
        throw new IllegalStateException("unsupported catalog type:" + type);
    }
}

