/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.metrics.promethues;

import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.amoro.api.metrics.MetricReporter;
import org.apache.amoro.api.metrics.MetricSet;
import org.apache.amoro.metrics.promethues.MetricsCollector;

public class PrometheusMetricsReporter
implements MetricReporter {
    public static final String PORT = "port";
    private HTTPServer server;

    public void open(Map<String, String> properties) {
        int port = Optional.ofNullable(properties.get(PORT)).map(Integer::valueOf).orElseThrow(() -> new IllegalArgumentException("Lack required property: port"));
        try {
            this.server = new HTTPServer(port);
        }
        catch (IOException e) {
            throw new RuntimeException("Start prometheus exporter server failed.", e);
        }
    }

    public void close() {
        this.server.close();
    }

    public String name() {
        return "prometheus-exporter";
    }

    public void setGlobalMetricSet(MetricSet globalMetricSet) {
        MetricsCollector collector = new MetricsCollector(globalMetricSet);
        collector.register();
    }
}

