/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.actions.ImmutableRewriteManifests;
import org.apache.iceberg.actions.RewriteManifests;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.SparkDataFile;
import org.apache.iceberg.spark.actions.BaseSnapshotUpdateSparkAction;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteManifestsSparkAction
extends BaseSnapshotUpdateSparkAction<RewriteManifestsSparkAction>
implements org.apache.iceberg.actions.RewriteManifests {
    public static final String USE_CACHING = "use-caching";
    public static final boolean USE_CACHING_DEFAULT = true;
    private static final Logger LOG = LoggerFactory.getLogger(RewriteManifestsSparkAction.class);
    private final Encoder<ManifestFile> manifestEncoder;
    private final Table table;
    private final int formatVersion;
    private final long targetManifestSizeBytes;
    private PartitionSpec spec = null;
    private Predicate<ManifestFile> predicate = manifest -> true;
    private String stagingLocation = null;

    RewriteManifestsSparkAction(SparkSession spark, Table table) {
        super(spark);
        this.manifestEncoder = Encoders.javaSerialization(ManifestFile.class);
        this.table = table;
        this.spec = table.spec();
        this.targetManifestSizeBytes = PropertyUtil.propertyAsLong((Map)table.properties(), (String)"commit.manifest.target-size-bytes", (long)0x800000L);
        TableOperations ops = ((HasTableOperations)table).operations();
        Path metadataFilePath = new Path(ops.metadataFileLocation("file"));
        this.stagingLocation = metadataFilePath.getParent().toString();
        this.formatVersion = ops.current().formatVersion();
    }

    @Override
    protected RewriteManifestsSparkAction self() {
        return this;
    }

    public RewriteManifestsSparkAction specId(int specId) {
        Preconditions.checkArgument((boolean)this.table.specs().containsKey(specId), (String)"Invalid spec id %s", (int)specId);
        this.spec = (PartitionSpec)this.table.specs().get(specId);
        return this;
    }

    public RewriteManifestsSparkAction rewriteIf(Predicate<ManifestFile> newPredicate) {
        this.predicate = newPredicate;
        return this;
    }

    public RewriteManifestsSparkAction stagingLocation(String newStagingLocation) {
        this.stagingLocation = newStagingLocation;
        return this;
    }

    public RewriteManifests.Result execute() {
        String desc = String.format("Rewriting manifests (staging location=%s) of %s", this.stagingLocation, this.table.name());
        JobGroupInfo info = this.newJobGroupInfo("REWRITE-MANIFESTS", desc);
        return this.withJobGroupInfo(info, this::doExecute);
    }

    private RewriteManifests.Result doExecute() {
        List<ManifestFile> matchingManifests = this.findMatchingManifests();
        if (matchingManifests.isEmpty()) {
            return ImmutableRewriteManifests.Result.builder().addedManifests((Iterable)ImmutableList.of()).rewrittenManifests((Iterable)ImmutableList.of()).build();
        }
        long totalSizeBytes = 0L;
        int numEntries = 0;
        for (ManifestFile manifest : matchingManifests) {
            ValidationException.check((boolean)this.hasFileCounts(manifest), (String)"No file counts in manifest: %s", (Object[])new Object[]{manifest.path()});
            totalSizeBytes += manifest.length();
            numEntries += manifest.addedFilesCount() + manifest.existingFilesCount() + manifest.deletedFilesCount();
        }
        int targetNumManifests = this.targetNumManifests(totalSizeBytes);
        int targetNumManifestEntries = this.targetNumManifestEntries(numEntries, targetNumManifests);
        if (targetNumManifests == 1 && matchingManifests.size() == 1) {
            return ImmutableRewriteManifests.Result.builder().addedManifests((Iterable)ImmutableList.of()).rewrittenManifests((Iterable)ImmutableList.of()).build();
        }
        Dataset<Row> manifestEntryDF = this.buildManifestEntryDF(matchingManifests);
        List<ManifestFile> newManifests = this.spec.fields().size() < 1 ? this.writeManifestsForUnpartitionedTable(manifestEntryDF, targetNumManifests) : this.writeManifestsForPartitionedTable(manifestEntryDF, targetNumManifests, targetNumManifestEntries);
        this.replaceManifests(matchingManifests, newManifests);
        return ImmutableRewriteManifests.Result.builder().rewrittenManifests(matchingManifests).addedManifests(newManifests).build();
    }

    private Dataset<Row> buildManifestEntryDF(List<ManifestFile> manifests) {
        Dataset manifestDF = this.spark().createDataset(Lists.transform(manifests, ManifestFile::path), Encoders.STRING()).toDF(new String[]{"manifest"});
        Dataset manifestEntryDF = this.loadMetadataTable(this.table, MetadataTableType.ENTRIES).filter("status < 2").selectExpr(new String[]{"input_file_name() as manifest", "snapshot_id", "sequence_number", "file_sequence_number", "data_file"});
        Column joinCond = manifestDF.col("manifest").equalTo((Object)manifestEntryDF.col("manifest"));
        return manifestEntryDF.join(manifestDF, joinCond, "left_semi").select("snapshot_id", new String[]{"sequence_number", "file_sequence_number", "data_file"});
    }

    private List<ManifestFile> writeManifestsForUnpartitionedTable(Dataset<Row> manifestEntryDF, int numManifests) {
        Broadcast tableBroadcast = this.sparkContext().broadcast((Object)SerializableTable.copyOf((Table)this.table));
        StructType sparkType = (StructType)manifestEntryDF.schema().apply("data_file").dataType();
        Types.StructType combinedPartitionType = Partitioning.partitionType((Table)this.table);
        long maxNumManifestEntries = Long.MAX_VALUE;
        return manifestEntryDF.repartition(numManifests).mapPartitions(RewriteManifestsSparkAction.toManifests((Broadcast<Table>)tableBroadcast, maxNumManifestEntries, this.stagingLocation, this.formatVersion, combinedPartitionType, this.spec, sparkType), this.manifestEncoder).collectAsList();
    }

    private List<ManifestFile> writeManifestsForPartitionedTable(Dataset<Row> manifestEntryDF, int numManifests, int targetNumManifestEntries) {
        Broadcast tableBroadcast = this.sparkContext().broadcast((Object)SerializableTable.copyOf((Table)this.table));
        StructType sparkType = (StructType)manifestEntryDF.schema().apply("data_file").dataType();
        Types.StructType combinedPartitionType = Partitioning.partitionType((Table)this.table);
        long maxNumManifestEntries = (long)(1.1 * (double)targetNumManifestEntries);
        return this.withReusableDS(manifestEntryDF, df -> {
            Column partitionColumn = df.col("data_file.partition");
            return df.repartitionByRange(numManifests, new Column[]{partitionColumn}).sortWithinPartitions(new Column[]{partitionColumn}).mapPartitions(RewriteManifestsSparkAction.toManifests((Broadcast<Table>)tableBroadcast, maxNumManifestEntries, this.stagingLocation, this.formatVersion, combinedPartitionType, this.spec, sparkType), this.manifestEncoder).collectAsList();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, U> U withReusableDS(Dataset<T> ds, Function<Dataset<T>, U> func) {
        Dataset reusableDS;
        boolean useCaching = PropertyUtil.propertyAsBoolean(this.options(), (String)USE_CACHING, (boolean)true);
        if (useCaching) {
            reusableDS = ds.cache();
        } else {
            int parallelism = SQLConf.get().numShufflePartitions();
            reusableDS = ds.repartition(parallelism).map((MapFunction & Serializable)value -> value, (Encoder)ds.exprEnc());
        }
        try {
            U u = func.apply(reusableDS);
            return u;
        }
        finally {
            if (useCaching) {
                reusableDS.unpersist(false);
            }
        }
    }

    private List<ManifestFile> findMatchingManifests() {
        Snapshot currentSnapshot = this.table.currentSnapshot();
        if (currentSnapshot == null) {
            return ImmutableList.of();
        }
        return currentSnapshot.dataManifests(this.table.io()).stream().filter(manifest -> manifest.partitionSpecId() == this.spec.specId() && this.predicate.test((ManifestFile)manifest)).collect(Collectors.toList());
    }

    private int targetNumManifests(long totalSizeBytes) {
        return (int)((totalSizeBytes + this.targetManifestSizeBytes - 1L) / this.targetManifestSizeBytes);
    }

    private int targetNumManifestEntries(int numEntries, int numManifests) {
        return (numEntries + numManifests - 1) / numManifests;
    }

    private boolean hasFileCounts(ManifestFile manifest) {
        return manifest.addedFilesCount() != null && manifest.existingFilesCount() != null && manifest.deletedFilesCount() != null;
    }

    private void replaceManifests(Iterable<ManifestFile> deletedManifests, Iterable<ManifestFile> addedManifests) {
        try {
            boolean snapshotIdInheritanceEnabled = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"compatibility.snapshot-id-inheritance.enabled", (boolean)false);
            RewriteManifests rewriteManifests = this.table.rewriteManifests();
            deletedManifests.forEach(arg_0 -> ((RewriteManifests)rewriteManifests).deleteManifest(arg_0));
            addedManifests.forEach(arg_0 -> ((RewriteManifests)rewriteManifests).addManifest(arg_0));
            this.commit((SnapshotUpdate<?>)rewriteManifests);
            if (!snapshotIdInheritanceEnabled) {
                this.deleteFiles(Iterables.transform(addedManifests, ManifestFile::path));
            }
        }
        catch (CommitStateUnknownException commitStateUnknownException) {
            throw commitStateUnknownException;
        }
        catch (Exception e) {
            this.deleteFiles(Iterables.transform(addedManifests, ManifestFile::path));
            throw e;
        }
    }

    private void deleteFiles(Iterable<String> locations) {
        Tasks.foreach(locations).executeWith(ThreadPools.getWorkerPool()).noRetry().suppressFailureWhenFinished().onFailure((location, exc) -> LOG.warn("Failed to delete: {}", location, (Object)exc)).run(location -> this.table.io().deleteFile(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ManifestFile writeManifest(List<Row> rows, int startIndex, int endIndex, Broadcast<Table> tableBroadcast, String location, int format, Types.StructType combinedPartitionType, PartitionSpec spec, StructType sparkType) throws IOException {
        String manifestName = "optimized-m-" + UUID.randomUUID();
        Path manifestPath = new Path(location, manifestName);
        OutputFile outputFile = ((Table)tableBroadcast.value()).io().newOutputFile(FileFormat.AVRO.addExtension(manifestPath.toString()));
        Types.StructType combinedFileType = DataFile.getType((Types.StructType)combinedPartitionType);
        Types.StructType manifestFileType = DataFile.getType((Types.StructType)spec.partitionType());
        SparkDataFile wrapper = new SparkDataFile(combinedFileType, manifestFileType, sparkType);
        try (ManifestWriter writer = ManifestFiles.write((int)format, (PartitionSpec)spec, (OutputFile)outputFile, null);){
            for (int index = startIndex; index < endIndex; ++index) {
                Row row = rows.get(index);
                long snapshotId = row.getLong(0);
                long sequenceNumber = row.getLong(1);
                Long fileSequenceNumber = row.isNullAt(2) ? null : Long.valueOf(row.getLong(2));
                Row file = row.getStruct(3);
                writer.existing((ContentFile)wrapper.wrap(file), snapshotId, sequenceNumber, fileSequenceNumber);
            }
        }
        return writer.toManifestFile();
    }

    private static MapPartitionsFunction<Row, ManifestFile> toManifests(Broadcast<Table> tableBroadcast, long maxNumManifestEntries, String location, int format, Types.StructType combinedPartitionType, PartitionSpec spec, StructType sparkType) {
        return (MapPartitionsFunction & Serializable)rows -> {
            ArrayList rowsAsList = Lists.newArrayList((Iterator)rows);
            if (rowsAsList.isEmpty()) {
                return Collections.emptyIterator();
            }
            ArrayList manifests = Lists.newArrayList();
            if ((long)rowsAsList.size() <= maxNumManifestEntries) {
                manifests.add(RewriteManifestsSparkAction.writeManifest(rowsAsList, 0, rowsAsList.size(), tableBroadcast, location, format, combinedPartitionType, spec, sparkType));
            } else {
                int midIndex = rowsAsList.size() / 2;
                manifests.add(RewriteManifestsSparkAction.writeManifest(rowsAsList, 0, midIndex, tableBroadcast, location, format, combinedPartitionType, spec, sparkType));
                manifests.add(RewriteManifestsSparkAction.writeManifest(rowsAsList, midIndex, rowsAsList.size(), tableBroadcast, location, format, combinedPartitionType, spec, sparkType));
            }
            return manifests.iterator();
        };
    }
}

