/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.Schema;
import org.apache.iceberg.types.FixupTypes;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;

class SparkFixupTypes
extends FixupTypes {
    private SparkFixupTypes(Schema referenceSchema) {
        super(referenceSchema);
    }

    static Schema fixup(Schema schema, Schema referenceSchema) {
        return new Schema(((Type)TypeUtil.visit((Schema)schema, (TypeUtil.CustomOrderSchemaVisitor)new SparkFixupTypes(referenceSchema))).asStructType().fields());
    }

    protected boolean fixupPrimitive(Type.PrimitiveType type, Type source) {
        switch (type.typeId()) {
            case STRING: {
                if (source.typeId() != Type.TypeID.UUID) break;
                return true;
            }
            case BINARY: {
                if (source.typeId() != Type.TypeID.FIXED) break;
                return true;
            }
            case TIMESTAMP: {
                if (source.typeId() != Type.TypeID.TIMESTAMP) break;
                return true;
            }
        }
        return false;
    }
}

