#!/usr/bin/env bash
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# Removes artifacts generated by cmake.

set -euo pipefail
. $IMPALA_HOME/bin/report_build_error.sh
setup_report_build_error

if [[ -z "${IMPALA_HOME}" || ! -d "${IMPALA_HOME}" ]]; then
  echo IMPALA_HOME=${IMPALA_HOME} is not valid. 1>&2
  exit 1
fi
# Remove trailing /
ROOT_DIR=${IMPALA_HOME%%/}
for loc in "${ROOT_DIR}/ -maxdepth 1" "${ROOT_DIR}/be/" "${ROOT_DIR}/java/" \
           "${ROOT_DIR}/common/" ; do
  find ${loc} \( -iname CMakeCache.txt -o -iname CMakeFiles \
       -o -iname CTestTestfile.cmake -o -iname cmake_install.cmake \) -exec rm -Rf {} +
done
rm -f ${IMPALA_HOME}/.cmake_build_type
