/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteCustomType;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeSystem;
import org.apache.ignite.internal.processors.query.calcite.type.OtherType;
import org.apache.ignite.internal.processors.query.calcite.type.UuidType;
import org.apache.ignite.internal.util.typedef.F;

public class IgniteTypeFactory
extends JavaTypeFactoryImpl {
    private static final EnumMap<SqlTypeName, String> UNSUPPORTED_TYPES = new EnumMap(SqlTypeName.class);
    private static final SqlIntervalQualifier INTERVAL_QUALIFIER_YEAR_MONTH;
    private static final SqlIntervalQualifier INTERVAL_QUALIFIER_DAY_TIME;
    private final Charset charset = SqlUtil.translateCharacterSetName((String)Charset.defaultCharset().name()) != null ? Charset.defaultCharset() : StandardCharsets.UTF_8;

    public IgniteTypeFactory() {
        this(IgniteTypeSystem.INSTANCE);
    }

    public IgniteTypeFactory(RelDataTypeSystem typeSystem) {
        super(typeSystem);
    }

    public Type getJavaClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: 
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: 
                case INTEGER: 
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case BIGINT: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return ByteString.class;
                }
                case GEOMETRY: {
                    throw new IllegalStateException("Unsupported data type: " + type);
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: 
                case OTHER: 
                case NULL: {
                    return Object.class;
                }
            }
        } else if (type instanceof IgniteCustomType) {
            return ((IgniteCustomType)type).storageType();
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    public Type getResultClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: {
                    return Date.class;
                }
                case TIME: {
                    return Time.class;
                }
                case TIMESTAMP: {
                    return Timestamp.class;
                }
                case TIME_WITH_LOCAL_TIME_ZONE: {
                    return LocalTime.class;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return LocalDateTime.class;
                }
                case INTEGER: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return Period.class;
                }
                case BIGINT: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return Duration.class;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return byte[].class;
                }
                case GEOMETRY: {
                    throw new IllegalStateException("Unsupported data type: " + type);
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: 
                case OTHER: {
                    return Object.class;
                }
                case NULL: {
                    return Void.class;
                }
            }
        } else if (type instanceof IgniteCustomType) {
            return ((IgniteCustomType)type).storageType();
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    public RelDataType leastRestrictive(List<RelDataType> types) {
        assert (types != null);
        assert (types.size() >= 1);
        if (types.size() == 1 || this.allEquals(types)) {
            return (RelDataType)F.first(types);
        }
        RelDataType res = super.leastRestrictive(types);
        if (res != null && res.getSqlTypeName() == SqlTypeName.FLOAT && types.size() > 1) {
            for (RelDataType type : types) {
                if (type.getSqlTypeName() != SqlTypeName.DOUBLE || type.getPrecision() < res.getPrecision()) continue;
                return type;
            }
        }
        return res;
    }

    public Charset getDefaultCharset() {
        return this.charset;
    }

    public RelDataType toSql(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            Class clazz = ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
            if (clazz == Duration.class) {
                return this.createTypeWithNullability(this.createSqlIntervalType(INTERVAL_QUALIFIER_DAY_TIME), true);
            }
            if (clazz == Period.class) {
                return this.createTypeWithNullability(this.createSqlIntervalType(INTERVAL_QUALIFIER_YEAR_MONTH), true);
            }
            if (clazz == LocalDateTime.class) {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.TIMESTAMP), true);
            }
            if (clazz == LocalDate.class) {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.DATE), true);
            }
            if (clazz == LocalTime.class) {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.TIME), true);
            }
            RelDataType relType = this.createCustomType(clazz);
            if (relType != null) {
                return relType;
            }
        }
        return super.toSql(type);
    }

    public RelDataType createCustomType(Type type) {
        return this.createCustomType(type, true);
    }

    public RelDataType createCustomType(Type type, boolean nullable) {
        if (UUID.class == type) {
            return this.canonize((RelDataType)new UuidType(nullable));
        }
        if (Object.class == type || type instanceof Class && BinaryObject.class.isAssignableFrom((Class)type)) {
            return this.canonize((RelDataType)new OtherType(nullable));
        }
        return null;
    }

    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        if (type instanceof IgniteCustomType && type.isNullable() != nullable) {
            return this.createCustomType(((IgniteCustomType)type).storageType(), nullable);
        }
        return super.createTypeWithNullability(type, nullable);
    }

    public RelDataType createType(Type type) {
        if (type == Duration.class || type == Period.class || type == LocalDateTime.class || type == LocalTime.class || type == LocalDate.class) {
            return this.createJavaType((Class)type);
        }
        RelDataType customType = this.createCustomType(type, false);
        if (customType != null) {
            return customType;
        }
        return super.createType(type);
    }

    private boolean allEquals(List<RelDataType> types) {
        assert (types.size() > 1);
        RelDataType first = (RelDataType)F.first(types);
        for (int i = 1; i < types.size(); ++i) {
            if (Objects.equals(first, types.get(i))) continue;
            return false;
        }
        return true;
    }

    public RelDataType createSqlType(SqlTypeName typeName) {
        IgniteTypeFactory.checkUnsupportedType(typeName);
        return super.createSqlType(typeName);
    }

    public RelDataType createSqlType(SqlTypeName typeName, int precision) {
        IgniteTypeFactory.checkUnsupportedType(typeName);
        return super.createSqlType(typeName, precision);
    }

    public RelDataType createSqlType(SqlTypeName typeName, int precision, int scale) {
        IgniteTypeFactory.checkUnsupportedType(typeName);
        return super.createSqlType(typeName, precision, scale);
    }

    private static void checkUnsupportedType(SqlTypeName typeName) {
        String unsupportedTypeName = UNSUPPORTED_TYPES.get(typeName);
        if (unsupportedTypeName != null) {
            throw new IgniteException("Type '" + unsupportedTypeName + "' is not supported.");
        }
    }

    public RelDataType createUnknownType() {
        return this.createTypeWithNullability(super.createUnknownType(), true);
    }

    static {
        UNSUPPORTED_TYPES.put(SqlTypeName.TIME_TZ, "TIME WITH TIME ZONE");
        UNSUPPORTED_TYPES.put(SqlTypeName.TIMESTAMP_TZ, "TIMESTAMP WITH TIME ZONE");
        UNSUPPORTED_TYPES.put(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, "TIMESTAMP WITH LOCAL TIME ZONE");
        UNSUPPORTED_TYPES.put(SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE, "TIME WITH LOCAL TIME ZONE");
        INTERVAL_QUALIFIER_YEAR_MONTH = new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO);
        INTERVAL_QUALIFIER_DAY_TIME = new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO);
    }
}

