/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlCreateIndex
extends SqlCreate {
    private final SqlIdentifier idxName;
    private final SqlIdentifier tblName;
    private final SqlNodeList columnList;
    private final SqlNumericLiteral parallel;
    private final SqlNumericLiteral inlineSize;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE INDEX", SqlKind.CREATE_INDEX);

    public IgniteSqlCreateIndex(SqlParserPos pos, boolean ifNotExists, @Nullable SqlIdentifier idxName, SqlIdentifier tblName, SqlNodeList columnList, SqlNumericLiteral parallel, SqlNumericLiteral inlineSize) {
        super(OPERATOR, pos, false, ifNotExists);
        this.idxName = idxName;
        this.tblName = Objects.requireNonNull(tblName, "table name");
        this.columnList = columnList;
        this.parallel = parallel;
        this.inlineSize = inlineSize;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.idxName, (Object)this.tblName, (Object)this.columnList, (Object)this.parallel, (Object)this.inlineSize);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("INDEX");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        if (this.idxName != null) {
            this.idxName.unparse(writer, 0, 0);
        }
        writer.keyword("ON");
        this.tblName.unparse(writer, 0, 0);
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlNode c : this.columnList) {
            writer.sep(",");
            boolean desc = false;
            if (c.getKind() == SqlKind.DESCENDING) {
                c = (SqlNode)((SqlCall)c).getOperandList().get(0);
                desc = true;
            }
            c.unparse(writer, 0, 0);
            if (!desc) continue;
            writer.keyword("DESC");
        }
        writer.endList(frame);
        if (this.parallel != null) {
            writer.keyword("PARALLEL");
            this.parallel.unparse(writer, 0, 0);
        }
        if (this.inlineSize != null) {
            writer.keyword("INLINE_SIZE");
            this.inlineSize.unparse(writer, 0, 0);
        }
    }

    public SqlIdentifier indexName() {
        return this.idxName;
    }

    public SqlIdentifier tableName() {
        return this.tblName;
    }

    public SqlNodeList columnList() {
        return this.columnList;
    }

    public SqlNumericLiteral parallel() {
        return this.parallel;
    }

    public SqlNumericLiteral inlineSize() {
        return this.inlineSize;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }
}

