/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class IgniteSqlAlterUser
extends SqlDdl {
    private final SqlIdentifier user;
    private final SqlLiteral pwd;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("ALTER USER", SqlKind.OTHER_DDL);

    public IgniteSqlAlterUser(SqlParserPos pos, SqlIdentifier user, SqlLiteral pwd) {
        super(OPERATOR, pos);
        this.user = Objects.requireNonNull(user, "user");
        this.pwd = Objects.requireNonNull(pwd, "password");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.user, (Object)this.pwd);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getOperator().getName());
        this.user.unparse(writer, 0, 0);
        writer.keyword("WITH PASSWORD");
        this.pwd.unparse(writer, 0, 0);
    }

    public SqlIdentifier user() {
        return this.user;
    }

    public String password() {
        return (String)this.pwd.getValueAs(String.class);
    }
}

