/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import java.lang.reflect.Method;
import java.util.Set;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoUtils;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;

public class IgniteMdCumulativeCost
implements MetadataHandler<BuiltInMetadata.CumulativeCost> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.CUMULATIVE_COST.method, (MetadataHandler)new IgniteMdCumulativeCost());

    public MetadataDef<BuiltInMetadata.CumulativeCost> getDef() {
        return BuiltInMetadata.CumulativeCost.DEF;
    }

    public RelOptCost getCumulativeCost(RelSubset rel, RelMetadataQuery mq) {
        return VolcanoUtils.bestCost(rel);
    }

    public RelOptCost getCumulativeCost(RelNode rel, RelMetadataQuery mq) {
        RelOptCost cost = IgniteMdCumulativeCost.nonCumulativeCost(rel, mq);
        if (cost.isInfinite()) {
            return cost;
        }
        for (RelNode input : rel.getInputs()) {
            RelOptCost inputCost = mq.getCumulativeCost(input);
            if (inputCost.isInfinite()) {
                return inputCost;
            }
            cost = cost.plus(inputCost);
        }
        return cost;
    }

    public RelOptCost getCumulativeCost(IgniteCorrelatedNestedLoopJoin rel, RelMetadataQuery mq) {
        RelOptCost cost = IgniteMdCumulativeCost.nonCumulativeCost((RelNode)rel, mq);
        if (cost.isInfinite()) {
            return cost;
        }
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        Set corIds = rel.getVariablesSet();
        RelOptCost leftCost = mq.getCumulativeCost(left);
        if (leftCost.isInfinite()) {
            return leftCost;
        }
        RelOptCost rightCost = mq.getCumulativeCost(right);
        if (rightCost.isInfinite()) {
            return rightCost;
        }
        return cost.plus(leftCost).plus(rightCost.multiplyBy(left.estimateRowCount(mq) / (double)corIds.size()));
    }

    private static RelOptCost nonCumulativeCost(RelNode rel, RelMetadataQuery mq) {
        RelOptCost cost = mq.getNonCumulativeCost(rel);
        if (cost.isInfinite()) {
            return cost;
        }
        RelOptCostFactory costFactory = rel.getCluster().getPlanner().getCostFactory();
        if (rel.getConvention() == Convention.NONE || TraitUtils.distribution(rel) == IgniteDistributions.any()) {
            return costFactory.makeInfiniteCost();
        }
        return costFactory.makeZeroCost().isLt(cost) ? cost : costFactory.makeTinyCost();
    }
}

