/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import org.apache.ignite.internal.sql.optimizer.affinity.PartitionAffinityFunctionType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PartitionTableAffinityDescriptor {
    private final PartitionAffinityFunctionType affFunc;
    private final int parts;
    private final boolean hasNodeFilter;
    private final String dataRegion;

    public PartitionTableAffinityDescriptor(PartitionAffinityFunctionType affFunc, int parts, boolean hasNodeFilter, String dataRegion) {
        this.affFunc = affFunc;
        this.parts = parts;
        this.hasNodeFilter = hasNodeFilter;
        this.dataRegion = dataRegion;
    }

    public boolean isCompatible(PartitionTableAffinityDescriptor other) {
        if (other == null) {
            return false;
        }
        if (this.affFunc == PartitionAffinityFunctionType.RENDEZVOUS && !this.hasNodeFilter) {
            return other.affFunc == PartitionAffinityFunctionType.RENDEZVOUS && !other.hasNodeFilter && other.parts == this.parts && F.eq(other.dataRegion, this.dataRegion);
        }
        return false;
    }

    public boolean isClientPartitionAwarenessApplicable() {
        return this.affFunc == PartitionAffinityFunctionType.RENDEZVOUS && !this.hasNodeFilter;
    }

    public int parts() {
        return this.parts;
    }

    public String toString() {
        return S.toString(PartitionTableAffinityDescriptor.class, this);
    }
}

