/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.tracing;

import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.Span;
import org.jetbrains.annotations.NotNull;

public class MTC {
    private static final Span NOOP_SPAN = NoopSpan.INSTANCE;
    private static ThreadLocal<Span> span = ThreadLocal.withInitial(() -> NOOP_SPAN);

    @NotNull
    public static Span span() {
        return span.get();
    }

    public static TraceSurroundings support(Span startSpan) {
        if (startSpan == null || startSpan == NOOP_SPAN) {
            return null;
        }
        Span oldSpan = MTC.span();
        span.set(startSpan);
        return new TraceSurroundings(oldSpan, true);
    }

    public static void supportInitial(Span startSpan) {
        span.set(startSpan);
    }

    public static TraceSurroundings supportContinual(Span startSpan) {
        if (startSpan == null || startSpan == NOOP_SPAN) {
            return null;
        }
        Span oldSpan = MTC.span();
        span.set(startSpan);
        return new TraceSurroundings(oldSpan, false);
    }

    public static class TraceSurroundings
    implements AutoCloseable {
        private final Span oldSpan;
        private final boolean endRequired;

        private TraceSurroundings(Span oldSpan, boolean endRequired) {
            this.oldSpan = oldSpan;
            this.endRequired = endRequired;
        }

        @Override
        public void close() {
            if (this.endRequired) {
                span.get().end();
            }
            span.set(this.oldSpan);
        }
    }
}

