/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.processors.metastorage.DistributedMetastorageLifecycleListener;
import org.apache.ignite.internal.processors.metastorage.ReadableDistributedMetaStorage;
import org.apache.ignite.internal.processors.metric.ConfigurableHistogramMetric;
import org.apache.ignite.internal.processors.metric.MetricRegistryImpl;
import org.apache.ignite.internal.processors.metric.SqlViewMetricExporterSpi;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.DoubleMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.metric.IgniteMetrics;
import org.apache.ignite.metric.MetricRegistry;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.metric.HistogramMetric;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricManager;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMetricManager
extends GridManagerAdapter<MetricExporterSpi>
implements ReadOnlyMetricManager {
    private static final long METRICS_UPDATE_FREQ = 3000L;
    public static final String SYS_METRICS = "sys";
    public static final String IGNITE_METRICS = "ignite";
    public static final String PME_METRICS = "pme";
    public static final String CLUSTER_METRICS = "cluster";
    public static final String CLIENT_CONNECTOR_METRICS = MetricUtils.metricName("client", "connector");
    public static final String TX_METRICS = "tx";
    public static final String GC_CPU_LOAD = "GcCpuLoad";
    public static final String GC_CPU_LOAD_DESCRIPTION = "GC CPU load.";
    public static final String CPU_LOAD = "CpuLoad";
    public static final String CPU_LOAD_DESCRIPTION = "CPU load.";
    public static final String UP_TIME = "UpTime";
    public static final String THREAD_CNT = "ThreadCount";
    public static final String PEAK_THREAD_CNT = "PeakThreadCount";
    public static final String TOTAL_STARTED_THREAD_CNT = "TotalStartedThreadCount";
    public static final String DAEMON_THREAD_CNT = "DaemonThreadCount";
    public static final String PME_DURATION = "Duration";
    public static final String PME_OPS_BLOCKED_DURATION = "CacheOperationsBlockedDuration";
    public static final String PME_DURATION_HISTOGRAM = "DurationHistogram";
    public static final String PME_OPS_BLOCKED_DURATION_HISTOGRAM = "CacheOperationsBlockedDurationHistogram";
    public static final String REBALANCED = "Rebalanced";
    public static final String CUSTOM_METRICS = "custom";
    private static final MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
    private static final OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
    private static final RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
    private static final ThreadMXBean threads = ManagementFactory.getThreadMXBean();
    private static final Collection<GarbageCollectorMXBean> gc = ManagementFactory.getGarbageCollectorMXBeans();
    public static final String HITRATE_CFG_PREFIX = MetricUtils.metricName("metrics", "hitrate");
    public static final String HISTOGRAM_CFG_PREFIX = MetricUtils.metricName("metrics", "histogram");
    private final ConcurrentHashMap<String, ReadOnlyMetricRegistry> registries = new ConcurrentHashMap();
    private final List<Consumer<ReadOnlyMetricRegistry>> metricRegCreationLsnrs = new CopyOnWriteArrayList<Consumer<ReadOnlyMetricRegistry>>();
    private final List<Consumer<ReadOnlyMetricRegistry>> metricRegRemoveLsnrs = new CopyOnWriteArrayList<Consumer<ReadOnlyMetricRegistry>>();
    private volatile ReadableDistributedMetaStorage roMetastorage;
    private volatile DistributedMetaStorage metastorage;
    private GridTimeoutProcessor.CancelableTask metricsUpdateTask;
    private final DoubleMetricImpl gcCpuLoad;
    private final DoubleMetricImpl cpuLoad;
    private final MemoryUsageMetrics heap;
    private final MemoryUsageMetrics nonHeap;
    private final SunOperatingSystemMXBeanAccessor sunOs = this.sunOperatingSystemMXBeanAccessor();
    private final IgniteMetrics customMetrics;

    public GridMetricManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])((Supplier<MetricExporterSpi[]>)() -> {
            MetricExporterSpi[] spi = ctx.config().getMetricExporterSpi();
            if (!IgniteComponentType.INDEXING.inClassPath() && !IgniteComponentType.QUERY_ENGINE.inClassPath()) {
                return spi;
            }
            MetricExporterSpi[] spiWithSql = new MetricExporterSpi[spi != null ? spi.length + 1 : 1];
            if (!F.isEmpty(spi)) {
                System.arraycopy(spi, 0, spiWithSql, 0, spi.length);
            }
            spiWithSql[spiWithSql.length - 1] = new SqlViewMetricExporterSpi();
            return spiWithSql;
        }).get());
        ctx.addNodeAttribute("org.apache.ignite.phy.ram", this.totalSysMemory());
        this.heap = new MemoryUsageMetrics(SYS_METRICS, MetricUtils.metricName("memory", "heap"));
        this.nonHeap = new MemoryUsageMetrics(SYS_METRICS, MetricUtils.metricName("memory", "nonheap"));
        this.heap.update(mem.getHeapMemoryUsage());
        this.nonHeap.update(mem.getNonHeapMemoryUsage());
        MetricRegistryImpl sysreg = this.registry(SYS_METRICS);
        this.gcCpuLoad = sysreg.doubleMetric(GC_CPU_LOAD, GC_CPU_LOAD_DESCRIPTION);
        this.cpuLoad = sysreg.doubleMetric(CPU_LOAD, CPU_LOAD_DESCRIPTION);
        sysreg.register("SystemLoadAverage", os::getSystemLoadAverage, Double.class, null);
        sysreg.register(UP_TIME, rt::getUptime, null);
        sysreg.register(THREAD_CNT, threads::getThreadCount, null);
        sysreg.register(PEAK_THREAD_CNT, threads::getPeakThreadCount, null);
        sysreg.register(TOTAL_STARTED_THREAD_CNT, threads::getTotalStartedThreadCount, null);
        sysreg.register(DAEMON_THREAD_CNT, threads::getDaemonThreadCount, null);
        sysreg.register("CurrentThreadCpuTime", threads::getCurrentThreadCpuTime, null);
        sysreg.register("CurrentThreadUserTime", threads::getCurrentThreadUserTime, null);
        MetricRegistryImpl pmeReg = this.registry(PME_METRICS);
        long[] pmeBounds = new long[]{500L, 1000L, 5000L, 30000L};
        pmeReg.histogram(PME_DURATION_HISTOGRAM, pmeBounds, "Histogram of PME durations in milliseconds.");
        pmeReg.histogram(PME_OPS_BLOCKED_DURATION_HISTOGRAM, pmeBounds, "Histogram of cache operations blocked PME durations in milliseconds.");
        this.customMetrics = new CustomMetricsImpl();
    }

    @Override
    protected void onKernalStart0() {
        this.metricsUpdateTask = this.ctx.timeout().schedule(new MetricsUpdater(), 3000L, 3000L);
    }

    @Override
    public void start() throws IgniteCheckedException {
        for (MetricExporterSpi spi : (MetricExporterSpi[])this.getSpis()) {
            spi.setMetricRegistry(this);
        }
        this.startSpi();
        if (this.ctx.internalSubscriptionProcessor() == null) {
            return;
        }
        this.ctx.internalSubscriptionProcessor().registerDistributedMetastorageListener(new DistributedMetastorageLifecycleListener(){

            @Override
            public void onReadyForRead(ReadableDistributedMetaStorage metastorage) {
                GridMetricManager.this.roMetastorage = metastorage;
                try {
                    metastorage.iterate(HITRATE_CFG_PREFIX, (name, val) -> GridMetricManager.this.onHitRateConfigChanged(name.substring(HITRATE_CFG_PREFIX.length() + 1), (Long)val));
                    metastorage.iterate(HISTOGRAM_CFG_PREFIX, (name, val) -> GridMetricManager.this.onHistogramConfigChanged(name.substring(HISTOGRAM_CFG_PREFIX.length() + 1), (long[])val));
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
                metastorage.listen(n -> n.startsWith(HITRATE_CFG_PREFIX), (name, oldVal, newVal) -> GridMetricManager.this.onHitRateConfigChanged(name.substring(HITRATE_CFG_PREFIX.length() + 1), (Long)newVal));
                metastorage.listen(n -> n.startsWith(HISTOGRAM_CFG_PREFIX), (name, oldVal, newVal) -> GridMetricManager.this.onHistogramConfigChanged(name.substring(HISTOGRAM_CFG_PREFIX.length() + 1), (long[])newVal));
            }

            @Override
            public void onReadyForWrite(DistributedMetaStorage metastorage) {
                GridMetricManager.this.metastorage = metastorage;
            }
        });
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
        U.closeQuiet(this.metricsUpdateTask);
    }

    public MetricRegistryImpl registry(String name) {
        boolean custom = name.startsWith(CUSTOM_METRICS);
        return (MetricRegistryImpl)this.registries.computeIfAbsent(name, n -> {
            MetricRegistryImpl mreg = new MetricRegistryImpl(name, custom ? null : mname -> (Long)this.readFromMetastorage(MetricUtils.metricName(HITRATE_CFG_PREFIX, mname)), custom ? null : mname -> (long[])this.readFromMetastorage(MetricUtils.metricName(HISTOGRAM_CFG_PREFIX, mname)), this.log);
            IgniteUtils.notifyListeners(mreg, this.metricRegCreationLsnrs, this.log);
            return mreg;
        });
    }

    private <T extends Serializable> T readFromMetastorage(String key) {
        if (this.roMetastorage == null) {
            return null;
        }
        try {
            return this.roMetastorage.read(key);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    public IgniteMetrics custom() {
        return this.customMetrics;
    }

    @Override
    @NotNull
    public Iterator<ReadOnlyMetricRegistry> iterator() {
        return this.registries.values().iterator();
    }

    @Override
    public void addMetricRegistryCreationListener(Consumer<ReadOnlyMetricRegistry> lsnr) {
        this.metricRegCreationLsnrs.add(lsnr);
    }

    @Override
    public void addMetricRegistryRemoveListener(Consumer<ReadOnlyMetricRegistry> lsnr) {
        this.metricRegRemoveLsnrs.add(lsnr);
    }

    public void remove(String regName) {
        this.remove(regName, true);
    }

    public void remove(String regName, boolean removeCfg) {
        GridCompoundFuture opsFut = new GridCompoundFuture();
        this.registries.computeIfPresent(regName, (key, mreg) -> {
            IgniteUtils.notifyListeners(mreg, this.metricRegRemoveLsnrs, this.log);
            if (!removeCfg) {
                return null;
            }
            DistributedMetaStorage metastorage0 = this.metastorage;
            if (metastorage0 == null) {
                return null;
            }
            try {
                for (Metric m : mreg) {
                    if (m instanceof HitRateMetric) {
                        opsFut.add(metastorage0.removeAsync(MetricUtils.metricName(HITRATE_CFG_PREFIX, m.name())));
                        continue;
                    }
                    if (!(m instanceof HistogramMetric)) continue;
                    opsFut.add(metastorage0.removeAsync(MetricUtils.metricName(HISTOGRAM_CFG_PREFIX, m.name())));
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            return null;
        });
        try {
            opsFut.markInitialized();
            opsFut.get();
        }
        catch (NodeStoppingException nodeStoppingException) {
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to remove metrics configuration.", e);
        }
    }

    public void configureHitRate(String name, long rateTimeInterval) throws IgniteCheckedException {
        A.notNullOrEmpty(name, "name");
        A.ensure(rateTimeInterval > 0L, "rateTimeInterval should be positive");
        A.notNull(this.metastorage, "Metastorage not ready. Node not started?");
        if (this.ctx.isStopping()) {
            throw new NodeStoppingException("Operation has been cancelled (node is stopping)");
        }
        this.ensureMetricRegistered(name, HitRateMetric.class);
        this.metastorage.write(MetricUtils.metricName(HITRATE_CFG_PREFIX, name), Long.valueOf(rateTimeInterval));
    }

    public void configureHistogram(String name, long[] bounds) throws IgniteCheckedException {
        A.notNullOrEmpty(name, "name");
        A.notEmpty(bounds, "bounds");
        A.notNull(this.metastorage, "Metastorage not ready. Node not started?");
        if (this.ctx.isStopping()) {
            throw new NodeStoppingException("Operation has been cancelled (node is stopping)");
        }
        this.ensureMetricRegistered(name, HistogramMetric.class);
        this.metastorage.write(MetricUtils.metricName(HISTOGRAM_CFG_PREFIX, name), (Serializable)bounds);
    }

    private void onHitRateConfigChanged(String name, @Nullable Long rateTimeInterval) {
        if (rateTimeInterval == null) {
            return;
        }
        A.ensure(rateTimeInterval > 0L, "rateTimeInterval should be positive");
        HitRateMetric m = this.find(name, HitRateMetric.class);
        if (m == null) {
            return;
        }
        m.reset(rateTimeInterval);
    }

    private void onHistogramConfigChanged(String name, @Nullable long[] bounds) {
        if (bounds == null) {
            return;
        }
        ConfigurableHistogramMetric m = this.find(name, ConfigurableHistogramMetric.class);
        if (m == null) {
            return;
        }
        try {
            m.bounds(bounds);
        }
        catch (RuntimeException e) {
            this.log.error("Error during histogram bounds reconfiguration", e);
        }
    }

    public <T extends Metric> T find(String name, Class<T> type) {
        A.notNull(name, "name");
        T2<String, String> splitted = MetricUtils.fromFullName(name);
        MetricRegistry mreg = (MetricRegistry)this.registries.get(splitted.get1());
        if (mreg == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Metric registry not found[registry=" + (String)splitted.get1() + "]");
            }
            return null;
        }
        Object m = mreg.findMetric((String)splitted.get2());
        if (m == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Metric not found[registry=" + (String)splitted.get1() + ", metricName=" + (String)splitted.get2() + "]");
            }
            return null;
        }
        if (!type.isAssignableFrom(m.getClass())) {
            this.log.error("Metric '" + name + "' has wrong type[type=" + m.getClass().getSimpleName() + "]");
            return null;
        }
        return (T)m;
    }

    public MemoryUsage nonHeapMemoryUsage() {
        try {
            return mem.getNonHeapMemoryUsage();
        }
        catch (IllegalArgumentException ignored) {
            return new MemoryUsage(0L, 0L, 0L, 0L);
        }
    }

    public MemoryUsage heapMemoryUsage() {
        try {
            return mem.getHeapMemoryUsage();
        }
        catch (IllegalArgumentException ignored) {
            return new MemoryUsage(0L, 0L, 0L, 0L);
        }
    }

    private <T extends Metric> void ensureMetricRegistered(String name, Class<T> cls) {
        if (this.find(name, cls) == null) {
            throw new IgniteException("Failed to find registered metric with specified name [metricName=" + name + "]");
        }
    }

    private long totalSysMemory() {
        try {
            return this.sunOs.getTotalPhysicalMemorySize();
        }
        catch (RuntimeException ignored) {
            return -1L;
        }
    }

    private SunOperatingSystemMXBeanAccessor sunOperatingSystemMXBeanAccessor() {
        try {
            if (os instanceof com.sun.management.OperatingSystemMXBean) {
                final com.sun.management.OperatingSystemMXBean sunOs = (com.sun.management.OperatingSystemMXBean)os;
                return new SunOperatingSystemMXBeanAccessor(){

                    @Override
                    public long getProcessCpuTime() {
                        return sunOs.getProcessCpuTime();
                    }

                    @Override
                    public long getTotalPhysicalMemorySize() {
                        return sunOs.getTotalPhysicalMemorySize();
                    }
                };
            }
        }
        catch (NoClassDefFoundError ignored) {
            this.log.warning("The 'com.sun.management.OperatingSystemMXBean' class is not available for class loader. System/JVM memory and CPU statistics may be not available.");
        }
        return new SunOperatingSystemMXBeanAccessor(){

            @Override
            public long getProcessCpuTime() {
                return (Long)U.property(os, "processCpuTime");
            }

            @Override
            public long getTotalPhysicalMemorySize() {
                return (Long)U.property(os, "totalPhysicalMemorySize");
            }
        };
    }

    private class CustomMetricsImpl
    implements IgniteMetrics {
        private CustomMetricsImpl() {
        }

        @Override
        public MetricRegistry getOrCreate(String registryName) {
            return GridMetricManager.this.registry(MetricUtils.customName(registryName));
        }

        @Override
        public void remove(String registryName) {
            GridMetricManager.this.remove(MetricUtils.customName(registryName), false);
        }

        @Override
        @NotNull
        public Iterator<ReadOnlyMetricRegistry> iterator() {
            return F.viewReadOnly(GridMetricManager.this.registries.values(), r -> r, r -> MetricUtils.customMetric(r.name())).iterator();
        }
    }

    private static interface SunOperatingSystemMXBeanAccessor {
        public long getProcessCpuTime();

        public long getTotalPhysicalMemorySize();
    }

    public class MemoryUsageMetrics {
        private final AtomicLongMetric init;
        private final AtomicLongMetric used;
        private final AtomicLongMetric committed;
        private final AtomicLongMetric max;

        public MemoryUsageMetrics(String grp, String metricNamePrefix) {
            MetricRegistryImpl mreg = GridMetricManager.this.registry(grp);
            this.init = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "init"), null);
            this.used = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "used"), null);
            this.committed = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "committed"), null);
            this.max = mreg.longMetric(MetricUtils.metricName(metricNamePrefix, "max"), null);
        }

        public void update(MemoryUsage usage) {
            this.init.value(usage.getInit());
            this.used.value(usage.getUsed());
            this.committed.value(usage.getCommitted());
            this.max.value(usage.getMax());
        }
    }

    private class MetricsUpdater
    implements Runnable {
        private long prevGcTime = -1L;
        private long prevCpuTime = -1L;

        private MetricsUpdater() {
        }

        @Override
        public void run() {
            GridMetricManager.this.heap.update(GridMetricManager.this.heapMemoryUsage());
            GridMetricManager.this.nonHeap.update(GridMetricManager.this.nonHeapMemoryUsage());
            GridMetricManager.this.gcCpuLoad.value(this.getGcCpuLoad());
            GridMetricManager.this.cpuLoad.value(this.getCpuLoad());
        }

        private double getGcCpuLoad() {
            long gcTime = 0L;
            for (GarbageCollectorMXBean bean : gc) {
                long colTime = bean.getCollectionTime();
                if (colTime <= 0L) continue;
                gcTime += colTime;
            }
            gcTime /= (long)os.getAvailableProcessors();
            double gc = 0.0;
            if (this.prevGcTime > 0L) {
                long gcTimeDiff = gcTime - this.prevGcTime;
                gc = (double)gcTimeDiff / 3000.0;
            }
            this.prevGcTime = gcTime;
            return gc;
        }

        private double getCpuLoad() {
            long cpuTime;
            try {
                cpuTime = GridMetricManager.this.sunOs.getProcessCpuTime();
            }
            catch (RuntimeException ignored) {
                return -1.0;
            }
            cpuTime /= (long)(1000000 * os.getAvailableProcessors());
            double cpu = 0.0;
            if (this.prevCpuTime > 0L) {
                long cpuTimeDiff = cpuTime - this.prevCpuTime;
                cpu = Math.min(1.0, (double)cpuTimeDiff / 3000.0);
            }
            this.prevCpuTime = cpuTime;
            return cpu;
        }

        public String toString() {
            return S.toString(MetricsUpdater.class, this, super.toString());
        }
    }
}

