/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.compress;

import java.nio.file.Path;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.processors.compress.NativeFileSystem;
import org.apache.ignite.internal.util.typedef.internal.U;

public final class FileSystemUtils {
    private static final String NATIVE_FS_LINUX_CLASS = "org.apache.ignite.internal.processors.compress.NativeFileSystemLinux";
    private static final NativeFileSystem fs;
    private static volatile Throwable err;

    public static void checkSupported() {
        Throwable e = err;
        if (e != null || fs == null) {
            throw new IgniteException("Native file system API is not supported on " + U.osString(), e);
        }
    }

    public static int getFileSystemBlockSize(Path path) {
        return fs == null ? -1 : fs.getFileSystemBlockSize(path);
    }

    public static int getFileSystemBlockSize(int fd) {
        return fs == null ? -1 : fs.getFileSystemBlockSize(fd);
    }

    public static long getSparseFileSize(int fd) {
        return fs == null ? -1L : fs.getSparseFileSize(fd);
    }

    public static long punchHole(int fd, long off, long len, int fsBlockSize) {
        long end;
        assert (off >= 0L);
        assert (len > 0L);
        FileSystemUtils.checkSupported();
        if (len < (long)fsBlockSize) {
            return 0L;
        }
        if (off % (long)fsBlockSize != 0L && (len = (end = off + len) - (off = (off / (long)fsBlockSize + 1L) * (long)fsBlockSize)) <= 0L) {
            return 0L;
        }
        if ((len = len / (long)fsBlockSize * (long)fsBlockSize) > 0L) {
            fs.punchHole(fd, off, len);
        }
        return len;
    }

    static {
        NativeFileSystem x = null;
        try {
            if (IgniteComponentType.COMPRESSION.inClassPath() && U.isLinux()) {
                x = (NativeFileSystem)U.newInstance(NATIVE_FS_LINUX_CLASS);
            }
        }
        catch (Throwable e) {
            err = e;
        }
        fs = x;
    }
}

