/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.compress;

import jnr.ffi.LibraryLoader;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.compress.NativeFileSystemPosix;

public final class NativeFileSystemLinux
extends NativeFileSystemPosix {
    public static final int FALLOC_FL_KEEP_SIZE = 1;
    public static final int FALLOC_FL_PUNCH_HOLE = 2;
    public static final int FALLOC_FL_NO_HIDE_STALE = 4;
    public static final int FALLOC_FL_COLLAPSE_RANGE = 8;
    public static final int FALLOC_FL_ZERO_RANGE = 16;
    public static final int FALLOC_FL_INSERT_RANGE = 32;
    public static final int FALLOC_FL_UNSHARE_RANGE = 64;
    private static final LinuxNativeLibC libc = (LinuxNativeLibC)LibraryLoader.create(LinuxNativeLibC.class).failImmediately().load("c");

    @Override
    public void punchHole(int fd, long off, long len) {
        int res = libc.fallocate(fd, 3, off, len);
        if (res != 0) {
            throw new IgniteException("errno: " + res);
        }
    }

    public static interface LinuxNativeLibC {
        public int fallocate(int var1, int var2, long var3, long var5);
    }
}

