/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class TablesWithAbortedTxnsHandler
implements QueryHandler<Set<String>> {
    private static final String SELECT_TABLES_WITH_X_ABORTED_TXNS = "SELECT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" FROM \"TXN_COMPONENTS\" INNER JOIN \"TXNS\" ON \"TC_TXNID\" = \"TXN_ID\" WHERE \"TXN_STATE\" = :abortedState GROUP BY \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" HAVING COUNT(\"TXN_ID\") > :txnThreshold";
    private final int txnThreshold;

    public TablesWithAbortedTxnsHandler(int txnThreshold) {
        this.txnThreshold = txnThreshold;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return SELECT_TABLES_WITH_X_ABORTED_TXNS;
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("abortedState", (Object)TxnStatus.ABORTED.getSqlConst(), 1).addValue("txnThreshold", (Object)this.txnThreshold);
    }

    public Set<String> extractData(ResultSet rs) throws SQLException, DataAccessException {
        TreeSet<String> resourceNames = new TreeSet<String>();
        while (rs.next()) {
            String resourceName = rs.getString(1) + "." + rs.getString(2);
            String partName = rs.getString(3);
            resourceName = partName != null ? resourceName + "#" + partName : resourceName;
            resourceNames.add(resourceName);
        }
        return resourceNames;
    }
}

