/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.tools.schematool.HiveSchemaHelper;
import org.apache.hadoop.hive.metastore.tools.schematool.MetastoreSchemaTool;
import org.apache.hadoop.hive.metastore.utils.MetastoreVersionInfo;

public class MetaStoreSchemaInfo
implements IMetaStoreSchemaInfo {
    protected static final String UPGRADE_FILE_PREFIX = "upgrade-";
    protected static final String INIT_FILE_PREFIX = "hive-schema-";
    protected static final String VERSION_UPGRADE_LIST = "upgrade.order";
    protected static final String PRE_UPGRADE_PREFIX = "pre-";
    protected static final String CREATE_USER_PREFIX = "create-user";
    private static final String VERSION_QUERY = "SELECT t.<q>SCHEMA_VERSION<q> from <q>VERSION<q> t";
    private String[] hiveSchemaVersions;
    private final String metastoreHome;
    protected final String dbType;
    private static final Map<String, String> EQUIVALENT_VERSIONS = ImmutableMap.of((Object)"0.13.1", (Object)"0.13.0", (Object)"1.0.0", (Object)"0.14.0", (Object)"1.0.1", (Object)"1.0.0", (Object)"1.1.1", (Object)"1.1.0", (Object)"1.2.1", (Object)"1.2.0");

    public MetaStoreSchemaInfo(String metastoreHome, String dbType) throws HiveMetaException {
        this.metastoreHome = metastoreHome;
        this.dbType = dbType;
    }

    private void loadAllUpgradeScripts(String dbType) throws HiveMetaException {
        ArrayList<String> upgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getMetaStoreScriptDir() + File.separator + "upgrade.order." + dbType;
        try (FileReader fr = new FileReader(upgradeListFile);
             BufferedReader bfReader = new BufferedReader(fr);){
            String currSchemaVersion;
            while ((currSchemaVersion = bfReader.readLine()) != null) {
                upgradeOrderList.add(currSchemaVersion.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new HiveMetaException("File " + upgradeListFile + "not found ", (Throwable)e);
        }
        catch (IOException e) {
            throw new HiveMetaException("Error reading " + upgradeListFile, (Throwable)e);
        }
        this.hiveSchemaVersions = upgradeOrderList.toArray(new String[0]);
    }

    @Override
    public List<String> getUpgradeScripts(String fromVersion) throws HiveMetaException {
        int i;
        ArrayList<String> upgradeScriptList = new ArrayList<String>();
        if (this.getHiveSchemaVersion().equals(fromVersion)) {
            return upgradeScriptList;
        }
        this.loadAllUpgradeScripts(this.dbType);
        int firstScript = this.hiveSchemaVersions.length;
        for (i = 0; i < this.hiveSchemaVersions.length; ++i) {
            if (!this.hiveSchemaVersions[i].startsWith(fromVersion + "-to-")) continue;
            firstScript = i;
        }
        if (firstScript == this.hiveSchemaVersions.length) {
            throw new HiveMetaException("Unknown version specified for upgrade " + fromVersion + " Metastore schema may be too old or newer");
        }
        for (i = firstScript; i < this.hiveSchemaVersions.length; ++i) {
            String scriptFile = this.generateUpgradeFileName(this.hiveSchemaVersions[i]);
            upgradeScriptList.add(scriptFile);
        }
        return upgradeScriptList;
    }

    @Override
    public String generateInitFileName(String toVersion) throws HiveMetaException {
        if (toVersion == null) {
            toVersion = this.getHiveSchemaVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + toVersion + "." + this.dbType + ".sql";
        File file = new File(this.getMetaStoreScriptDir() + File.separatorChar + initScriptName);
        if (!file.exists()) {
            throw new HiveMetaException("Unknown version specified for initialization: " + toVersion, (Throwable)new NoSuchFileException(file.getAbsolutePath()));
        }
        return initScriptName;
    }

    @Override
    public String getCreateUserScript() throws HiveMetaException {
        String createScript = "create-user." + this.dbType + ".sql";
        File scriptFile = new File(this.getMetaStoreScriptDir() + File.separatorChar + createScript);
        if (!scriptFile.exists()) {
            throw new HiveMetaException("Unable to find create user file, expected: " + scriptFile.getAbsolutePath());
        }
        return createScript;
    }

    @Override
    public String getMetaStoreScriptDir() {
        return this.metastoreHome + File.separatorChar + "scripts" + File.separatorChar + "metastore" + File.separatorChar + "upgrade" + File.separatorChar + this.dbType;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return UPGRADE_FILE_PREFIX + fileVersion + "." + this.dbType + ".sql";
    }

    @Override
    public String getPreUpgradeScriptName(int index, String upgradeScriptName) {
        return PRE_UPGRADE_PREFIX + index + "-" + upgradeScriptName;
    }

    @Override
    public String getHiveSchemaVersion() {
        String hiveVersion = MetastoreVersionInfo.getShortVersion();
        return MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion);
    }

    private static String getEquivalentVersion(String hiveVersion) {
        String equivalentVersion = EQUIVALENT_VERSIONS.get(hiveVersion);
        if (equivalentVersion != null) {
            return equivalentVersion;
        }
        return hiveVersion;
    }

    @Override
    public boolean isVersionCompatible(String hiveVersion, String dbVersion) {
        if ((hiveVersion = MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion)).equals(dbVersion = MetaStoreSchemaInfo.getEquivalentVersion(dbVersion))) {
            return true;
        }
        String[] hiveVerParts = hiveVersion.split("\\.");
        String[] dbVerParts = dbVersion.split("\\.");
        if (hiveVerParts.length != 3 || dbVerParts.length != 3) {
            return false;
        }
        hiveVerParts = hiveVersion.split("\\.|-");
        dbVerParts = dbVersion.split("\\.|-");
        for (int i = 0; i < Math.min(hiveVerParts.length, dbVerParts.length); ++i) {
            int compare = this.compareVersion(dbVerParts[i], hiveVerParts[i]);
            if (compare == 0) continue;
            return compare > 0;
        }
        return hiveVerParts.length > dbVerParts.length;
    }

    private int compareVersion(String dbVerPart, String hiveVerPart) {
        if (dbVerPart.equals(hiveVerPart)) {
            return 0;
        }
        boolean isDbVerNum = StringUtils.isNumeric((CharSequence)dbVerPart);
        boolean isHiveVerNum = StringUtils.isNumeric((CharSequence)hiveVerPart);
        if (isDbVerNum && isHiveVerNum) {
            return Integer.parseInt(dbVerPart) - Integer.parseInt(hiveVerPart);
        }
        if (!isDbVerNum && !isHiveVerNum) {
            return dbVerPart.compareTo(hiveVerPart);
        }
        return -1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMetaStoreSchemaVersion(HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo) throws HiveMetaException {
        HiveSchemaHelper.NestedScriptParser db = HiveSchemaHelper.getDbCommandParser(connectionInfo.getDbType(), connectionInfo.getMetaDbType(), false);
        String schema = "hive".equals(connectionInfo.getDbType()) ? "SYS" : null;
        try (Connection metastoreDbConnection = HiveSchemaHelper.getConnectionToMetastore(connectionInfo, schema);){
            String string;
            block16: {
                Statement stmt = metastoreDbConnection.createStatement();
                try {
                    ResultSet res = stmt.executeQuery(MetastoreSchemaTool.quote(VERSION_QUERY, db.needsQuotedIdentifier(), db.getQuoteCharacter()));
                    if (!res.next()) {
                        throw new HiveMetaException("Could not find version info in metastore VERSION table.");
                    }
                    String currentSchemaVersion = res.getString(1);
                    if (res.next()) {
                        throw new HiveMetaException("Multiple versions were found in metastore.");
                    }
                    string = currentSchemaVersion;
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get schema version, Cause:" + e.getMessage());
        }
    }
}

