/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.List;
import org.apache.iceberg.EnvironmentContext;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.ImmutableSQLViewRepresentation;
import org.apache.iceberg.view.ImmutableViewVersion;
import org.apache.iceberg.view.ReplaceViewVersion;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewVersion;

class ViewVersionReplace
implements ReplaceViewVersion {
    private final ViewOperations ops;
    private final List<ViewRepresentation> representations = Lists.newArrayList();
    private ViewMetadata base;
    private Namespace defaultNamespace = null;
    private String defaultCatalog = null;
    private Schema schema = null;

    ViewVersionReplace(ViewOperations ops) {
        this.ops = ops;
        this.base = ops.current();
    }

    @Override
    public ViewVersion apply() {
        return this.internalApply().currentVersion();
    }

    ViewMetadata internalApply() {
        Preconditions.checkState(!this.representations.isEmpty(), "Cannot replace view without specifying a query");
        Preconditions.checkState(null != this.schema, "Cannot replace view without specifying schema");
        Preconditions.checkState(null != this.defaultNamespace, "Cannot replace view without specifying a default namespace");
        this.base = this.ops.refresh();
        ViewVersion viewVersion = this.base.currentVersion();
        int maxVersionId = this.base.versions().stream().map(ViewVersion::versionId).max(Integer::compareTo).orElseGet(viewVersion::versionId);
        ImmutableViewVersion newVersion = ImmutableViewVersion.builder().versionId(maxVersionId + 1).timestampMillis(System.currentTimeMillis()).schemaId(this.schema.schemaId()).defaultNamespace(this.defaultNamespace).defaultCatalog(this.defaultCatalog).putAllSummary(EnvironmentContext.get()).addAllRepresentations(this.representations).build();
        return ViewMetadata.buildFrom(this.base).setCurrentVersion(newVersion, this.schema).build();
    }

    @Override
    public void commit() {
        Tasks.foreach(this.ops).retry(PropertyUtil.propertyAsInt(this.base.properties(), "commit.retry.num-retries", 4)).exponentialBackoff(PropertyUtil.propertyAsInt(this.base.properties(), "commit.retry.min-wait-ms", 100), PropertyUtil.propertyAsInt(this.base.properties(), "commit.retry.max-wait-ms", 60000), PropertyUtil.propertyAsInt(this.base.properties(), "commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> taskOps.commit(this.base, this.internalApply()));
    }

    @Override
    public ReplaceViewVersion withQuery(String dialect, String sql) {
        this.representations.add(ImmutableSQLViewRepresentation.builder().dialect(dialect).sql(sql).build());
        return this;
    }

    @Override
    public ReplaceViewVersion withSchema(Schema newSchema) {
        this.schema = newSchema;
        return this;
    }

    @Override
    public ReplaceViewVersion withDefaultCatalog(String catalog) {
        this.defaultCatalog = catalog;
        return this;
    }

    @Override
    public ReplaceViewVersion withDefaultNamespace(Namespace namespace) {
        this.defaultNamespace = namespace;
        return this;
    }
}

