/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.data.CachingDeleteLoader;
import org.apache.iceberg.data.DeleteLoader;
import org.apache.iceberg.data.GenericDeleteFilter;
import org.apache.iceberg.data.IdentityPartitionConverters;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.IcebergAcidUtil;
import org.apache.iceberg.mr.mapreduce.AbstractIcebergRecordReader;
import org.apache.iceberg.mr.mapreduce.HiveIdentityPartitionConverters;
import org.apache.iceberg.mr.mapreduce.IcebergInternalRecordWrapper;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PartitionUtil;

public final class IcebergRecordReader<T>
extends AbstractIcebergRecordReader<T> {
    private static final String HIVE_VECTORIZED_READER_CLASS = "org.apache.iceberg.mr.hive.vector.HiveVectorizedReader";
    private static final DynMethods.StaticMethod HIVE_VECTORIZED_READER_BUILDER = HiveVersion.min(HiveVersion.HIVE_3) ? DynMethods.builder("reader").impl("org.apache.iceberg.mr.hive.vector.HiveVectorizedReader", Table.class, Path.class, FileScanTask.class, Map.class, TaskAttemptContext.class, Expression.class, Schema.class).buildStatic() : null;
    private Iterator<FileScanTask> tasks;
    private CloseableIterator<T> currentIterator;
    private T current;

    @Override
    public void initialize(InputSplit split, TaskAttemptContext newContext) {
        super.initialize(split, newContext);
        ScanTaskGroup<FileScanTask> taskGroup = ((IcebergSplit)split).taskGroup();
        this.tasks = taskGroup.tasks().iterator();
        this.currentIterator = this.nextTask();
    }

    private CloseableIterator<T> nextTask() {
        Iterator closeableIterator = this.open(this.tasks.next(), this.expectedSchema).iterator();
        if (!this.isFetchVirtualColumns() || Utilities.getIsVectorized((Configuration)this.conf)) {
            return closeableIterator;
        }
        return new IcebergAcidUtil.VirtualColumnAwareIterator(closeableIterator, this.expectedSchema, this.conf, this.table);
    }

    public boolean nextKeyValue() throws IOException {
        while (!this.currentIterator.hasNext()) {
            this.currentIterator.close();
            if (!this.tasks.hasNext()) {
                return false;
            }
            this.currentIterator = this.nextTask();
        }
        this.current = this.currentIterator.next();
        return true;
    }

    public T getCurrentValue() {
        return this.current;
    }

    public void close() throws IOException {
        this.currentIterator.close();
    }

    private CloseableIterable<T> openVectorized(FileScanTask task, Schema readSchema) {
        Preconditions.checkArgument(!((DataFile)task.file()).format().equals((Object)FileFormat.AVRO), "Vectorized execution is not yet supported for Iceberg avro tables. Please turn off vectorization and retry the query.");
        Preconditions.checkArgument(HiveVersion.min(HiveVersion.HIVE_3), "Vectorized read is unsupported for Hive 2 integration.");
        Path path = new Path(((DataFile)task.file()).path().toString());
        Map<Integer, ?> idToConstant = this.constantsMap(task, HiveIdentityPartitionConverters::convertConstant);
        Expression residual = HiveIcebergInputFormat.residualForTask(task, this.getContext().getConfiguration());
        CloseableIterable iterator = (CloseableIterable)HIVE_VECTORIZED_READER_BUILDER.invoke(this.table, path, task, idToConstant, this.getContext(), residual, readSchema);
        return this.applyResidualFiltering(iterator, residual, readSchema);
    }

    private CloseableIterable openGeneric(FileScanTask task, Schema readSchema) {
        if (task.isDataTask()) {
            IcebergInternalRecordWrapper wrapper = new IcebergInternalRecordWrapper(this.table.schema().asStruct(), readSchema.asStruct());
            return CloseableIterable.transform(((DataTask)task).rows(), wrapper::wrap);
        }
        DataFile file = (DataFile)task.file();
        InputFile inputFile = this.table.encryption().decrypt(EncryptedFiles.encryptedInput(this.table.io().newInputFile(file.path().toString()), file.keyMetadata()));
        return switch (file.format()) {
            case FileFormat.AVRO -> this.newAvroIterable(inputFile, task, readSchema);
            case FileFormat.ORC -> this.newOrcIterable(inputFile, task, readSchema);
            case FileFormat.PARQUET -> this.newParquetIterable(inputFile, task, readSchema);
            default -> throw new UnsupportedOperationException(String.format("Cannot read %s file: %s", file.format().name(), file.path()));
        };
    }

    private CloseableIterable<T> open(FileScanTask currentTask, Schema readSchema) {
        switch (this.getInMemoryDataModel()) {
            case HIVE: {
                return this.openVectorized(currentTask, readSchema);
            }
            case GENERIC: {
                GenericDeleteFilter deletes = new GenericDeleteFilter(this.table.io(), currentTask, this.table.schema(), readSchema){

                    @Override
                    protected DeleteLoader newDeleteLoader() {
                        return new CachingDeleteLoader(x$0 -> this.loadInputFile((DeleteFile)x$0), IcebergRecordReader.this.conf);
                    }
                };
                Schema requiredSchema = deletes.requiredSchema();
                return deletes.filter(this.openGeneric(currentTask, requiredSchema));
            }
        }
        throw new UnsupportedOperationException("Unsupported memory model");
    }

    private CloseableIterable<T> newAvroIterable(InputFile inputFile, FileScanTask task, Schema readSchema) {
        Expression residual = HiveIcebergInputFormat.residualForTask(task, this.getContext().getConfiguration());
        Avro.ReadBuilder avroReadBuilder = Avro.read(inputFile).project(readSchema).split(task.start(), task.length());
        if (this.isReuseContainers()) {
            avroReadBuilder.reuseContainers();
        }
        if (this.getNameMapping() != null) {
            avroReadBuilder.withNameMapping(NameMappingParser.fromJson(this.getNameMapping()));
        }
        avroReadBuilder.createReaderFunc((expIcebergSchema, expAvroSchema) -> DataReader.create(expIcebergSchema, expAvroSchema, this.constantsMap(task, IdentityPartitionConverters::convertConstant)));
        return this.applyResidualFiltering(avroReadBuilder.build(), residual, readSchema);
    }

    private CloseableIterable<T> newParquetIterable(InputFile inputFile, FileScanTask task, Schema readSchema) {
        Expression residual = HiveIcebergInputFormat.residualForTask(task, this.getContext().getConfiguration());
        Parquet.ReadBuilder parquetReadBuilder = Parquet.read(inputFile).project(readSchema).filter(residual).caseSensitive(this.isCaseSensitive()).split(task.start(), task.length());
        if (this.isReuseContainers()) {
            parquetReadBuilder.reuseContainers();
        }
        if (this.getNameMapping() != null) {
            parquetReadBuilder.withNameMapping(NameMappingParser.fromJson(this.getNameMapping()));
        }
        parquetReadBuilder.createReaderFunc(fileSchema -> GenericParquetReaders.buildReader(readSchema, fileSchema, this.constantsMap(task, IdentityPartitionConverters::convertConstant)));
        return this.applyResidualFiltering(parquetReadBuilder.build(), residual, readSchema);
    }

    private CloseableIterable<T> newOrcIterable(InputFile inputFile, FileScanTask task, Schema readSchema) {
        Map<Integer, ?> idToConstant = this.constantsMap(task, IdentityPartitionConverters::convertConstant);
        Schema readSchemaWithoutConstantAndMetadataFields = IcebergRecordReader.schemaWithoutConstantsAndMeta(readSchema, idToConstant);
        Expression residual = HiveIcebergInputFormat.residualForTask(task, this.getContext().getConfiguration());
        ORC.ReadBuilder orcReadBuilder = ORC.read(inputFile).project(readSchemaWithoutConstantAndMetadataFields).filter(residual).caseSensitive(this.isCaseSensitive()).split(task.start(), task.length());
        if (this.getNameMapping() != null) {
            orcReadBuilder.withNameMapping(NameMappingParser.fromJson(this.getNameMapping()));
        }
        orcReadBuilder.createReaderFunc(fileSchema -> GenericOrcReader.buildReader(readSchema, fileSchema, idToConstant));
        return this.applyResidualFiltering(orcReadBuilder.build(), residual, readSchema);
    }

    private Map<Integer, ?> constantsMap(FileScanTask task, BiFunction<Type, Object, Object> converter) {
        boolean projectsIdentityPartitionColumns;
        PartitionSpec spec = task.spec();
        Set<Integer> idColumns = spec.identitySourceIds();
        Schema partitionSchema = TypeUtil.select(this.expectedSchema, idColumns);
        boolean bl = projectsIdentityPartitionColumns = !partitionSchema.columns().isEmpty();
        if (this.expectedSchema.findField(0x7FFFFFFA) != null) {
            Types.StructType partitionType = Partitioning.partitionType(this.table);
            return PartitionUtil.constantsMap(task, partitionType, converter);
        }
        if (projectsIdentityPartitionColumns) {
            Types.StructType partitionType = Partitioning.partitionType(this.table);
            return PartitionUtil.constantsMap(task, partitionType, converter);
        }
        return Collections.emptyMap();
    }

    private static Schema schemaWithoutConstantsAndMeta(Schema readSchema, Map<Integer, ?> idToConstant) {
        Set partitionFields = Optional.ofNullable(readSchema.findField(0x7FFFFFFA)).map(Types.NestedField::type).map(Type::asStructType).map(Types.StructType::fields).map(fields -> fields.stream().map(Types.NestedField::fieldId).collect(Collectors.toSet())).orElseGet(Collections::emptySet);
        Set<Integer> collect = Stream.of(idToConstant.keySet(), MetadataColumns.metadataFieldIds(), partitionFields).flatMap(Collection::stream).collect(Collectors.toSet());
        return TypeUtil.selectNot(readSchema, collect);
    }
}

