/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Term;

public abstract class Aggregate<C extends Term>
implements Expression {
    private final Expression.Operation op;
    private final C term;

    Aggregate(Expression.Operation op, C term) {
        this.op = op;
        this.term = term;
    }

    @Override
    public Expression.Operation op() {
        return this.op;
    }

    public C term() {
        return this.term;
    }

    public String toString() {
        switch (this.op()) {
            case COUNT: {
                return "count(" + this.term() + ")";
            }
            case COUNT_STAR: {
                return "count(*)";
            }
            case MAX: {
                return "max(" + this.term() + ")";
            }
            case MIN: {
                return "min(" + this.term() + ")";
            }
        }
        throw new UnsupportedOperationException("Invalid aggregate: " + this.op());
    }
}

