/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.events.CreateSnapshotEvent;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.Tasks;

public class BaseRewriteManifests
extends SnapshotProducer<RewriteManifests>
implements RewriteManifests {
    private final String tableName;
    private final Map<Integer, PartitionSpec> specsById;
    private final long manifestTargetSizeBytes;
    private final Set<ManifestFile> deletedManifests = Sets.newHashSet();
    private final List<ManifestFile> addedManifests = Lists.newArrayList();
    private final List<ManifestFile> rewrittenAddedManifests = Lists.newArrayList();
    private final Collection<ManifestFile> keptManifests = new ConcurrentLinkedQueue<ManifestFile>();
    private final Collection<ManifestFile> newManifests = new ConcurrentLinkedQueue<ManifestFile>();
    private final Set<ManifestFile> rewrittenManifests = Sets.newConcurrentHashSet();
    private final Map<Object, WriterWrapper> writers = Maps.newConcurrentMap();
    private final AtomicLong entryCount = new AtomicLong(0L);
    private Function<DataFile, Object> clusterByFunc;
    private Predicate<ManifestFile> predicate;
    private final SnapshotSummary.Builder summaryBuilder = SnapshotSummary.builder();

    BaseRewriteManifests(String tableName, TableOperations ops) {
        super(ops);
        this.tableName = tableName;
        this.specsById = this.ops().current().specsById();
        this.manifestTargetSizeBytes = this.ops().current().propertyAsLong("commit.manifest.target-size-bytes", 0x800000L);
    }

    @Override
    protected RewriteManifests self() {
        return this;
    }

    @Override
    protected String operation() {
        return "replace";
    }

    @Override
    public RewriteManifests set(String property, String value) {
        this.summaryBuilder.set(property, value);
        return this;
    }

    @Override
    protected Map<String, String> summary() {
        int createdManifestsCount = this.newManifests.size() + this.addedManifests.size() + this.rewrittenAddedManifests.size();
        this.summaryBuilder.set("manifests-created", String.valueOf(createdManifestsCount));
        this.summaryBuilder.set("manifests-kept", String.valueOf(this.keptManifests.size()));
        this.summaryBuilder.set("manifests-replaced", String.valueOf(this.rewrittenManifests.size() + this.deletedManifests.size()));
        this.summaryBuilder.set("entries-processed", String.valueOf(this.entryCount.get()));
        this.summaryBuilder.setPartitionSummaryLimit(0);
        return this.summaryBuilder.build();
    }

    @Override
    public RewriteManifests clusterBy(Function<DataFile, Object> func) {
        this.clusterByFunc = func;
        return this;
    }

    @Override
    public RewriteManifests rewriteIf(Predicate<ManifestFile> pred) {
        this.predicate = pred;
        return this;
    }

    @Override
    public RewriteManifests deleteManifest(ManifestFile manifest) {
        this.deletedManifests.add(manifest);
        return this;
    }

    @Override
    public RewriteManifests addManifest(ManifestFile manifest) {
        Preconditions.checkArgument(!manifest.hasAddedFiles(), "Cannot add manifest with added files");
        Preconditions.checkArgument(!manifest.hasDeletedFiles(), "Cannot add manifest with deleted files");
        Preconditions.checkArgument(manifest.snapshotId() == null || manifest.snapshotId() == -1L, "Snapshot id must be assigned during commit");
        Preconditions.checkArgument(manifest.sequenceNumber() == -1L, "Sequence must be assigned during commit");
        if (this.canInheritSnapshotId() && manifest.snapshotId() == null) {
            this.addedManifests.add(manifest);
        } else {
            ManifestFile copiedManifest = this.copyManifest(manifest);
            this.rewrittenAddedManifests.add(copiedManifest);
        }
        return this;
    }

    private ManifestFile copyManifest(ManifestFile manifest) {
        TableMetadata current = this.ops().current();
        InputFile toCopy = this.ops().io().newInputFile(manifest);
        EncryptedOutputFile newFile = this.newManifestOutputFile();
        return ManifestFiles.copyRewriteManifest(current.formatVersion(), manifest.partitionSpecId(), manifest.firstRowId(), toCopy, this.specsById, newFile, this.snapshotId(), this.summaryBuilder);
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base, Snapshot snapshot) {
        List<ManifestFile> currentManifests = base.currentSnapshot().allManifests(this.ops().io());
        ImmutableSet<ManifestFile> currentManifestSet = ImmutableSet.copyOf(currentManifests);
        this.validateDeletedManifests(currentManifestSet, base.currentSnapshot().snapshotId());
        if (this.requiresRewrite(currentManifestSet)) {
            this.performRewrite(currentManifests);
        } else {
            this.keepActiveManifests(currentManifests);
        }
        this.validateFilesCounts();
        Iterable newManifestsWithMetadata = Iterables.transform(Iterables.concat(this.newManifests, this.addedManifests, this.rewrittenAddedManifests), manifest -> GenericManifestFile.copyOf(manifest).withSnapshotId(this.snapshotId()).build());
        ArrayList<ManifestFile> apply = Lists.newArrayList();
        Iterables.addAll(apply, newManifestsWithMetadata);
        apply.addAll(this.keptManifests);
        return apply;
    }

    @Override
    public Object updateEvent() {
        long snapshotId = this.snapshotId();
        Snapshot snapshot = this.ops().current().snapshot(snapshotId);
        long sequenceNumber = snapshot.sequenceNumber();
        return new CreateSnapshotEvent(this.tableName, this.operation(), snapshotId, sequenceNumber, snapshot.summary());
    }

    private boolean requiresRewrite(Set<ManifestFile> currentManifests) {
        if (this.clusterByFunc == null) {
            return false;
        }
        if (this.rewrittenManifests.isEmpty()) {
            return true;
        }
        return this.rewrittenManifests.stream().anyMatch(manifest -> !currentManifests.contains(manifest));
    }

    private void keepActiveManifests(List<ManifestFile> currentManifests) {
        this.keptManifests.clear();
        currentManifests.stream().filter(manifest -> !this.rewrittenManifests.contains(manifest) && !this.deletedManifests.contains(manifest)).forEach(this.keptManifests::add);
    }

    private void reset() {
        this.cleanUncommitted(this.newManifests, ImmutableSet.of());
        this.entryCount.set(0L);
        this.keptManifests.clear();
        this.rewrittenManifests.clear();
        this.newManifests.clear();
        this.writers.clear();
    }

    private void performRewrite(List<ManifestFile> currentManifests) {
        this.reset();
        List remainingManifests = currentManifests.stream().filter(manifest -> !this.deletedManifests.contains(manifest)).collect(Collectors.toList());
        try {
            Tasks.foreach(remainingManifests).executeWith(this.workerPool()).run(manifest -> {
                if (this.containsDeletes((ManifestFile)manifest) || !this.matchesPredicate((ManifestFile)manifest)) {
                    this.keptManifests.add((ManifestFile)manifest);
                } else {
                    this.rewrittenManifests.add((ManifestFile)manifest);
                    try (ManifestReader<DataFile> reader = ManifestFiles.read(manifest, this.ops().io(), this.ops().current().specsById()).select(Collections.singletonList("*"));){
                        reader.liveEntries().forEach(entry -> this.appendEntry((ManifestEntry<DataFile>)entry, this.clusterByFunc.apply((DataFile)entry.file()), manifest.partitionSpecId()));
                    }
                    catch (IOException x) {
                        throw new RuntimeIOException(x);
                    }
                }
            });
        }
        finally {
            Tasks.foreach(this.writers.values()).executeWith(this.workerPool()).run(WriterWrapper::close);
        }
    }

    private boolean containsDeletes(ManifestFile manifest) {
        return manifest.content() == ManifestContent.DELETES;
    }

    private boolean matchesPredicate(ManifestFile manifest) {
        return this.predicate == null || this.predicate.test(manifest);
    }

    private void validateDeletedManifests(Set<ManifestFile> currentManifests, long currentSnapshotID) {
        this.deletedManifests.stream().filter(manifest -> !currentManifests.contains(manifest)).findAny().ifPresent(manifest -> {
            throw new ValidationException("Deleted manifest %s could not be found in the latest snapshot %d", manifest.path(), currentSnapshotID);
        });
    }

    private void validateFilesCounts() {
        Iterable<ManifestFile> replacedManifests;
        int replacedManifestsFilesCount;
        Iterable<ManifestFile> createdManifests = Iterables.concat(this.newManifests, this.addedManifests, this.rewrittenAddedManifests);
        int createdManifestsFilesCount = this.activeFilesCount(createdManifests);
        if (createdManifestsFilesCount != (replacedManifestsFilesCount = this.activeFilesCount(replacedManifests = Iterables.concat(this.rewrittenManifests, this.deletedManifests)))) {
            throw new ValidationException("Replaced and created manifests must have the same number of active files: %d (new), %d (old)", createdManifestsFilesCount, replacedManifestsFilesCount);
        }
    }

    private int activeFilesCount(Iterable<ManifestFile> manifests) {
        int activeFilesCount = 0;
        for (ManifestFile manifest : manifests) {
            Preconditions.checkNotNull(manifest.addedFilesCount(), "Missing file counts in %s", (Object)manifest.path());
            Preconditions.checkNotNull(manifest.existingFilesCount(), "Missing file counts in %s", (Object)manifest.path());
            activeFilesCount += manifest.addedFilesCount().intValue();
            activeFilesCount += manifest.existingFilesCount().intValue();
        }
        return activeFilesCount;
    }

    private void appendEntry(ManifestEntry<DataFile> entry, Object key, int partitionSpecId) {
        Preconditions.checkNotNull(entry, "Manifest entry cannot be null");
        Preconditions.checkNotNull(key, "Key cannot be null");
        WriterWrapper writer = this.getWriter(key, partitionSpecId);
        writer.addEntry(entry);
        this.entryCount.incrementAndGet();
    }

    private WriterWrapper getWriter(Object key, int partitionSpecId) {
        return this.writers.computeIfAbsent(Pair.of(key, partitionSpecId), k -> new WriterWrapper(this.specsById.get(partitionSpecId)));
    }

    @Override
    protected void cleanUncommitted(Set<ManifestFile> committed) {
        this.cleanUncommitted(this.newManifests, committed);
        this.cleanUncommitted(this.rewrittenAddedManifests, committed);
    }

    private void cleanUncommitted(Iterable<ManifestFile> manifests, Set<ManifestFile> committedManifests) {
        for (ManifestFile manifest : manifests) {
            if (committedManifests.contains(manifest)) continue;
            this.deleteFile(manifest.path());
        }
    }

    long getManifestTargetSizeBytes() {
        return this.manifestTargetSizeBytes;
    }

    class WriterWrapper {
        private final PartitionSpec spec;
        private ManifestWriter<DataFile> writer;

        WriterWrapper(PartitionSpec spec) {
            this.spec = spec;
        }

        synchronized void addEntry(ManifestEntry<DataFile> entry) {
            if (this.writer == null) {
                this.writer = BaseRewriteManifests.this.newManifestWriter(this.spec);
            } else if (this.writer.length() >= BaseRewriteManifests.this.getManifestTargetSizeBytes()) {
                this.close();
                this.writer = BaseRewriteManifests.this.newManifestWriter(this.spec);
            }
            this.writer.existing(entry);
        }

        synchronized void close() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                    BaseRewriteManifests.this.newManifests.add(this.writer.toManifestFile());
                }
                catch (IOException x) {
                    throw new RuntimeIOException(x);
                }
            }
        }
    }
}

