/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

public class NumberUtils {
    static final double TheNaN = Double.NaN;

    public static int snap(int v, int minv, int maxv) {
        return v < minv ? minv : (v > maxv ? maxv : v);
    }

    public static long snap(long v, long minv, long maxv) {
        return v < minv ? minv : (v > maxv ? maxv : v);
    }

    public static double snap(double v, double minv, double maxv) {
        return v < minv ? minv : (v > maxv ? maxv : v);
    }

    static int sizeOf(double v) {
        return 8;
    }

    static int sizeOfDouble() {
        return 8;
    }

    static int sizeOf(int v) {
        return 4;
    }

    static int sizeOf(long v) {
        return 8;
    }

    static int sizeOf(byte v) {
        return 1;
    }

    static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    static double NaN() {
        return Double.NaN;
    }

    public static int hashCombine(int hash1, int hash2) {
        return hash1 * 31 + hash2 & Integer.MAX_VALUE;
    }

    static int hash(int n) {
        int hash = 5381;
        hash = (hash << 5) + hash + (n & 0xFF);
        hash = (hash << 5) + hash + (n >> 8 & 0xFF);
        hash = (hash << 5) + hash + (n >> 16 & 0xFF);
        hash = (hash << 5) + hash + (n >> 24 & 0xFF);
        return hash &= Integer.MAX_VALUE;
    }

    static int hash(double d) {
        long bits = Double.doubleToLongBits(d);
        int hc = (int)(bits ^ bits >>> 32);
        return NumberUtils.hash(hc);
    }

    static int hash(int hashIn, int n) {
        int hash = (hashIn << 5) + hashIn + (n & 0xFF);
        hash = (hash << 5) + hash + (n >> 8 & 0xFF);
        hash = (hash << 5) + hash + (n >> 16 & 0xFF);
        hash = (hash << 5) + hash + (n >> 24 & 0xFF);
        return hash &= Integer.MAX_VALUE;
    }

    static int hash(int hash, double d) {
        long bits = Double.doubleToLongBits(d);
        int hc = (int)(bits ^ bits >>> 32);
        return NumberUtils.hash(hash, hc);
    }

    static long doubleToInt64Bits(double d) {
        return Double.doubleToLongBits(d);
    }

    static double negativeInf() {
        return Double.NEGATIVE_INFINITY;
    }

    static double positiveInf() {
        return Double.POSITIVE_INFINITY;
    }

    static int intMax() {
        return Integer.MAX_VALUE;
    }

    static double doubleEps() {
        return 2.220446049250313E-16;
    }

    static double doubleMax() {
        return Double.MAX_VALUE;
    }

    static int nextRand(int prevRand) {
        return 1103515245 * prevRand + 12345 & NumberUtils.intMax();
    }

    static boolean isEqualNonIEEE(double a, double b) {
        return a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    static boolean isEqualNonIEEE(double a, double b, double tolerance) {
        return a == b || Math.abs(a - b) <= tolerance || Double.isNaN(a) && Double.isNaN(b);
    }
}

