/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import java.util.Arrays;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.theta.ObjectInspectorValidator;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="intersectSketch", value="_FUNC_(sketch, seed) - Compute the intersection of sketches", extended="Example:\n> SELECT intersectSketch(sketch) FROM src;\nThe return value is a binary blob that contains a compact sketch, which can be operated on by the other sketch-related functions. The seed is optional, and using it is not recommended unless you really know why you need it.")
public class IntersectSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length < 1) {
            throw new UDFArgumentException("Please specify at least 1 argument");
        }
        if (inspectors.length > 2) {
            throw new UDFArgumentTypeException(inspectors.length - 1, "Please specify no more than 2 arguments");
        }
        ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[0], 0, PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        if (inspectors.length > 1) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[1], 1);
        }
        return new IntersectSketchUDAFEvaluator();
    }

    static class IntersectSketchUDAFEvaluator
    extends GenericUDAFEvaluator {
        protected static final String SEED_FIELD = "seed";
        protected static final String SKETCH_FIELD = "sketch";
        private transient PrimitiveObjectInspector inputObjectInspector;
        protected transient PrimitiveObjectInspector seedObjectInspector;
        protected transient StructObjectInspector intermediateObjectInspector;

        IntersectSketchUDAFEvaluator() {
        }

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            super.init(mode, parameters);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputObjectInspector = (PrimitiveObjectInspector)parameters[0];
                if (parameters.length > 1) {
                    this.seedObjectInspector = (PrimitiveObjectInspector)parameters[1];
                }
            } else {
                this.intermediateObjectInspector = (StandardStructObjectInspector)parameters[0];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList(SEED_FIELD, SKETCH_FIELD), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] data) throws HiveException {
            byte[] serializedSketch;
            if (data[0] == null) {
                return;
            }
            IntersectionState state = (IntersectionState)buf;
            if (!state.isInitialized()) {
                long seed = 9001L;
                if (this.seedObjectInspector != null) {
                    seed = PrimitiveObjectInspectorUtils.getLong((Object)data[1], (PrimitiveObjectInspector)this.seedObjectInspector);
                }
                state.init(seed);
            }
            if ((serializedSketch = (byte[])this.inputObjectInspector.getPrimitiveJavaObject(data[0])) == null) {
                return;
            }
            state.update(Memory.wrap((byte[])serializedSketch));
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
            IntersectionState state = (IntersectionState)buf;
            Sketch intermediate = state.getResult();
            if (intermediate == null) {
                return null;
            }
            byte[] bytes = intermediate.toByteArray();
            return Arrays.asList(new LongWritable(state.getSeed()), new BytesWritable(bytes));
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object data) throws HiveException {
            if (data == null) {
                return;
            }
            IntersectionState state = (IntersectionState)buf;
            if (!state.isInitialized()) {
                long seed = ((LongWritable)this.intermediateObjectInspector.getStructFieldData(data, this.intermediateObjectInspector.getStructFieldRef(SEED_FIELD))).get();
                state.init(seed);
            }
            Memory serializedSketch = BytesWritableHelper.wrapAsMemory((BytesWritable)this.intermediateObjectInspector.getStructFieldData(data, this.intermediateObjectInspector.getStructFieldRef(SKETCH_FIELD)));
            state.update(serializedSketch);
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
            IntersectionState state = (IntersectionState)buf;
            Sketch resultSketch = state.getResult();
            if (resultSketch == null) {
                return null;
            }
            return new BytesWritable(resultSketch.toByteArray());
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new IntersectionState();
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
            IntersectionState state = (IntersectionState)buf;
            state.reset();
        }

        static class IntersectionState
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            private long seed_;
            private Intersection intersection_;

            IntersectionState() {
            }

            boolean isInitialized() {
                return this.intersection_ != null;
            }

            void init(long seed) {
                this.seed_ = seed;
                this.intersection_ = SetOperation.builder().setSeed(seed).buildIntersection();
            }

            long getSeed() {
                return this.seed_;
            }

            void update(Memory serializedSketch) {
                this.intersection_.intersect(Sketches.wrapSketch((Memory)serializedSketch, (long)this.seed_));
            }

            Sketch getResult() {
                if (this.intersection_ == null) {
                    return null;
                }
                return this.intersection_.getResult();
            }

            void reset() {
                this.intersection_ = null;
            }
        }
    }
}

