/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.discovery;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasRelationshipHeader;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasSearchResult
implements Serializable {
    private AtlasQueryType queryType;
    private SearchParameters searchParameters;
    private String queryText;
    private String type;
    private String classification;
    private List<AtlasEntityHeader> entities;
    private List<AtlasRelationshipHeader> relations;
    private AttributeSearchResult attributes;
    private List<AtlasFullTextResult> fullTextResult;
    private Map<String, AtlasEntityHeader> referredEntities;
    private long approximateCount = -1L;
    private String nextMarker;

    public AtlasSearchResult() {
    }

    public AtlasSearchResult(AtlasQueryType queryType) {
        this(null, queryType);
    }

    public AtlasSearchResult(String queryText, AtlasQueryType queryType) {
        this.setQueryText(queryText);
        this.setQueryType(queryType);
        this.setSearchParameters(null);
        this.setEntities(null);
        this.setRelations(null);
        this.setAttributes(null);
        this.setFullTextResult(null);
        this.setReferredEntities(null);
    }

    public AtlasSearchResult(SearchParameters searchParameters) {
        this.setQueryType(AtlasQueryType.BASIC);
        if (searchParameters != null) {
            this.setQueryText(searchParameters.getQuery());
            this.setSearchParameters(searchParameters);
            this.setEntities(null);
            this.setRelations(null);
            this.setAttributes(null);
            this.setFullTextResult(null);
            this.setReferredEntities(null);
        }
    }

    public AtlasQueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(AtlasQueryType queryType) {
        this.queryType = queryType;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public List<AtlasEntityHeader> getEntities() {
        return this.entities;
    }

    public void setEntities(List<AtlasEntityHeader> entities) {
        this.entities = entities;
    }

    public List<AtlasRelationshipHeader> getRelations() {
        return this.relations;
    }

    public void setRelations(List<AtlasRelationshipHeader> relations) {
        this.relations = relations;
    }

    public AttributeSearchResult getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeSearchResult attributes) {
        this.attributes = attributes;
    }

    public List<AtlasFullTextResult> getFullTextResult() {
        return this.fullTextResult;
    }

    public void setFullTextResult(List<AtlasFullTextResult> fullTextResult) {
        this.fullTextResult = fullTextResult;
    }

    public Map<String, AtlasEntityHeader> getReferredEntities() {
        return this.referredEntities;
    }

    public void setReferredEntities(Map<String, AtlasEntityHeader> referredEntities) {
        this.referredEntities = referredEntities;
    }

    public long getApproximateCount() {
        return this.approximateCount;
    }

    public void setApproximateCount(long approximateCount) {
        this.approximateCount = approximateCount;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queryType, this.searchParameters, this.queryText, this.type, this.classification, this.entities, this.relations, this.attributes, this.fullTextResult, this.referredEntities, this.nextMarker});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasSearchResult that = (AtlasSearchResult)o;
        return Objects.equals((Object)this.queryType, (Object)that.queryType) && Objects.equals(this.searchParameters, that.searchParameters) && Objects.equals(this.queryText, that.queryText) && Objects.equals(this.type, that.type) && Objects.equals(this.classification, that.classification) && Objects.equals(this.entities, that.entities) && Objects.equals(this.relations, that.relations) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.fullTextResult, that.fullTextResult) && Objects.equals(this.referredEntities, that.referredEntities) && Objects.equals(this.nextMarker, that.nextMarker);
    }

    public void addEntity(AtlasEntityHeader newEntity) {
        if (this.entities == null) {
            this.entities = new ArrayList<AtlasEntityHeader>();
        }
        if (this.entities.isEmpty()) {
            this.entities.add(newEntity);
        } else {
            this.removeEntity(newEntity);
            this.entities.add(newEntity);
        }
    }

    public void removeEntity(AtlasEntityHeader entity) {
        List<AtlasEntityHeader> entities = this.entities;
        if (CollectionUtils.isNotEmpty(entities)) {
            Iterator<AtlasEntityHeader> iter = entities.iterator();
            while (iter.hasNext()) {
                AtlasEntityHeader currEntity = iter.next();
                if (!StringUtils.equals((String)currEntity.getGuid(), (String)entity.getGuid())) continue;
                iter.remove();
            }
        }
    }

    public void addRelation(AtlasRelationshipHeader relation) {
        if (this.relations == null) {
            this.relations = new ArrayList<AtlasRelationshipHeader>();
        }
        if (this.relations.isEmpty()) {
            this.relations.add(relation);
        } else {
            this.removeRelation(relation);
            this.relations.add(relation);
        }
    }

    public void removeRelation(AtlasRelationshipHeader relation) {
        List<AtlasRelationshipHeader> relations = this.relations;
        if (CollectionUtils.isNotEmpty(relations)) {
            Iterator<AtlasRelationshipHeader> iter = relations.iterator();
            while (iter.hasNext()) {
                AtlasRelationshipHeader currEntity = iter.next();
                if (!StringUtils.equals((String)currEntity.getGuid(), (String)relation.getGuid())) continue;
                iter.remove();
            }
        }
    }

    public String toString() {
        return "AtlasSearchResult{queryType=" + (Object)((Object)this.queryType) + ", searchParameters='" + this.searchParameters + '\'' + ", queryText='" + this.queryText + '\'' + ", type=" + this.type + ", classification=" + this.classification + ", entities=" + this.entities + ", relations=" + this.relations + ", attributes=" + this.attributes + ", fullTextResult=" + this.fullTextResult + ", referredEntities=" + this.referredEntities + ", approximateCount=" + this.approximateCount + ", nextMarker=" + this.nextMarker + '}';
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasFullTextResult {
        AtlasEntityHeader entity;
        Double score;

        public AtlasFullTextResult() {
        }

        public AtlasFullTextResult(AtlasEntityHeader entity, Double score) {
            this.entity = entity;
            this.score = score;
        }

        public AtlasEntityHeader getEntity() {
            return this.entity;
        }

        public void setEntity(AtlasEntityHeader entity) {
            this.entity = entity;
        }

        public Double getScore() {
            return this.score;
        }

        public void setScore(Double score) {
            this.score = score;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasFullTextResult that = (AtlasFullTextResult)o;
            return Objects.equals(this.entity, that.entity) && Objects.equals(this.score, that.score);
        }

        public int hashCode() {
            return Objects.hash(this.entity, this.score);
        }

        public String toString() {
            return "AtlasFullTextResult{entity=" + this.entity + ", score=" + this.score + '}';
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AttributeSearchResult {
        private List<String> name;
        private List<List<Object>> values;

        public AttributeSearchResult() {
        }

        public AttributeSearchResult(List<String> name, List<List<Object>> values) {
            this.name = name;
            this.values = values;
        }

        public List<String> getName() {
            return this.name;
        }

        public void setName(List<String> name) {
            this.name = name;
        }

        public List<List<Object>> getValues() {
            return this.values;
        }

        public void setValues(List<List<Object>> values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeSearchResult that = (AttributeSearchResult)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.values);
        }

        public String toString() {
            return "AttributeSearchResult{name=" + this.name + ", values=" + this.values + '}';
        }
    }

    public static enum AtlasQueryType {
        DSL,
        FULL_TEXT,
        GREMLIN,
        BASIC,
        ATTRIBUTE,
        RELATIONSHIP;

    }
}

