/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.orc.OrcFile;

public class MergeFiles {
    public static void main(Configuration conf, String[] args) throws Exception {
        String[] files;
        Options opts = MergeFiles.createOptions();
        CommandLine cli = new DefaultParser().parse(opts, args);
        HelpFormatter formatter = new HelpFormatter();
        if (cli.hasOption('h')) {
            formatter.printHelp("merge", opts);
            return;
        }
        String outputFilename = cli.getOptionValue("output");
        if (outputFilename == null || outputFilename.isEmpty()) {
            System.err.println("output filename is null");
            formatter.printHelp("merge", opts);
            return;
        }
        boolean ignoreExtension = cli.hasOption("ignoreExtension");
        ArrayList<Path> inputFiles = new ArrayList<Path>();
        OrcFile.WriterOptions writerOptions = OrcFile.writerOptions((Configuration)conf);
        for (String root : files = cli.getArgs()) {
            Path rootPath = new Path(root);
            FileSystem fs = rootPath.getFileSystem(conf);
            RemoteIterator itr = fs.listFiles(rootPath, true);
            while (itr.hasNext()) {
                LocatedFileStatus status = (LocatedFileStatus)itr.next();
                if (!status.isFile() || !ignoreExtension && !status.getPath().getName().endsWith(".orc")) continue;
                inputFiles.add(status.getPath());
            }
        }
        if (inputFiles.isEmpty()) {
            System.err.println("No files found.");
            System.exit(1);
        }
        List mergedFiles = OrcFile.mergeFiles((Path)new Path(outputFilename), (OrcFile.WriterOptions)writerOptions, inputFiles);
        ArrayList<Path> unSuccessMergedFiles = new ArrayList<Path>();
        if (mergedFiles.size() != inputFiles.size()) {
            HashSet mergedFilesSet = new HashSet(mergedFiles);
            for (Path inputFile : inputFiles) {
                if (mergedFilesSet.contains(inputFile)) continue;
                unSuccessMergedFiles.add(inputFile);
            }
        }
        if (!unSuccessMergedFiles.isEmpty()) {
            System.err.println("List of files that could not be merged:");
            unSuccessMergedFiles.forEach(path -> System.err.println(path.toString()));
        }
        System.out.printf("Output path: %s, Input files size: %d, Merge files size: %d%n", outputFilename, inputFiles.size(), mergedFiles.size());
        if (!unSuccessMergedFiles.isEmpty()) {
            System.exit(1);
        }
    }

    private static Options createOptions() {
        Options result = new Options();
        result.addOption(Option.builder((String)"o").longOpt("output").desc("Output filename").hasArg().build());
        result.addOption(Option.builder((String)"i").longOpt("ignoreExtension").desc("Ignore ORC file extension").build());
        result.addOption(Option.builder((String)"h").longOpt("help").desc("Print help message").build());
        return result;
    }
}

