/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.benchmark.vectorization;

import java.util.Random;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.RandomTypeUtil;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ColumnVectorGenUtil {
    private static final long LONG_VECTOR_NULL_VALUE = 1L;
    private static final double DOUBLE_VECTOR_NULL_VALUE = Double.NaN;

    public static VectorizedRowBatch getVectorizedRowBatch(int size, int numCol, int seed) {
        VectorizedRowBatch vrg = new VectorizedRowBatch(numCol, size);
        for (int j = 0; j < numCol; ++j) {
            LongColumnVector lcv = new LongColumnVector(size);
            for (int i = 0; i < size; ++i) {
                lcv.vector[i] = (i + 1) * seed * (j + 1);
            }
            vrg.cols[j] = lcv;
        }
        vrg.size = size;
        return vrg;
    }

    public static ColumnVector generateColumnVector(TypeInfo typeInfo, boolean nulls, boolean repeating, int size, Random rand) {
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case DATE: {
                    return ColumnVectorGenUtil.generateLongColumnVector(nulls, repeating, size, rand);
                }
                case FLOAT: 
                case DOUBLE: {
                    return ColumnVectorGenUtil.generateDoubleColumnVector(nulls, repeating, size, rand);
                }
                case DECIMAL: {
                    return ColumnVectorGenUtil.generateDecimalColumnVector((DecimalTypeInfo)typeInfo, nulls, repeating, size, rand);
                }
                case CHAR: 
                case VARCHAR: 
                case STRING: 
                case BINARY: {
                    return ColumnVectorGenUtil.generateBytesColumnVector(nulls, repeating, size, rand);
                }
                case TIMESTAMP: {
                    return ColumnVectorGenUtil.generateTimestampColumnVector(nulls, repeating, size, rand);
                }
            }
        }
        throw new RuntimeException("Unsupported type info category: " + typeInfo.getCategory());
    }

    public static BytesColumnVector generateBytesColumnVector(boolean nulls, boolean repeating, int size, Random rand) {
        BytesColumnVector bcv = new BytesColumnVector(size);
        bcv.initBuffer(10);
        bcv.noNulls = !nulls;
        bcv.isRepeating = repeating;
        byte[] repeatingValue = new byte[10];
        rand.nextBytes(repeatingValue);
        int nullFrequency = ColumnVectorGenUtil.generateNullFrequency(rand);
        for (int i = 0; i < size; ++i) {
            if (nulls && (repeating || i % nullFrequency == 0)) {
                bcv.isNull[i] = true;
                bcv.setVal(0, new byte[]{0});
                continue;
            }
            bcv.isNull[i] = false;
            if (repeating) {
                bcv.setVal(i, repeatingValue, 0, repeatingValue.length);
                continue;
            }
            String val = String.valueOf("value_" + i);
            bcv.setVal(i, val.getBytes(), 0, val.length());
        }
        return bcv;
    }

    public static LongColumnVector generateLongColumnVector(boolean nulls, boolean repeating, int size, Random rand) {
        long repeatingValue;
        LongColumnVector lcv = new LongColumnVector(size);
        lcv.noNulls = !nulls;
        lcv.isRepeating = repeating;
        while ((repeatingValue = rand.nextLong()) == 0L) {
        }
        int nullFrequency = ColumnVectorGenUtil.generateNullFrequency(rand);
        for (int i = 0; i < size; ++i) {
            if (nulls && (repeating || i % nullFrequency == 0)) {
                lcv.isNull[i] = true;
                lcv.vector[i] = 1L;
                continue;
            }
            lcv.isNull[i] = false;
            long l = lcv.vector[i] = repeating ? repeatingValue : rand.nextLong();
            if (lcv.vector[i] != 0L) continue;
            --i;
        }
        return lcv;
    }

    private static ColumnVector generateTimestampColumnVector(boolean nulls, boolean repeating, int size, Random rand) {
        Timestamp[] timestamps = new Timestamp[size];
        for (int i = 0; i < size; ++i) {
            timestamps[i] = Timestamp.ofEpochMilli((long)rand.nextInt());
        }
        return ColumnVectorGenUtil.generateTimestampColumnVector(nulls, repeating, size, rand, timestamps);
    }

    public static TimestampColumnVector generateTimestampColumnVector(boolean nulls, boolean repeating, int size, Random rand, Timestamp[] timestampValues) {
        TimestampColumnVector tcv = new TimestampColumnVector(size);
        tcv.noNulls = !nulls;
        tcv.isRepeating = repeating;
        Timestamp repeatingTimestamp = RandomTypeUtil.getRandTimestamp((Random)rand);
        int nullFrequency = ColumnVectorGenUtil.generateNullFrequency(rand);
        for (int i = 0; i < size; ++i) {
            if (nulls && (repeating || i % nullFrequency == 0)) {
                tcv.isNull[i] = true;
                tcv.setNullValue(i);
                timestampValues[i] = null;
                continue;
            }
            tcv.isNull[i] = false;
            if (!repeating) {
                Timestamp randomTimestamp = RandomTypeUtil.getRandTimestamp((Random)rand);
                tcv.set(i, randomTimestamp.toSqlTimestamp());
                timestampValues[i] = randomTimestamp;
                continue;
            }
            tcv.set(i, repeatingTimestamp.toSqlTimestamp());
            timestampValues[i] = repeatingTimestamp;
        }
        return tcv;
    }

    public static DoubleColumnVector generateDoubleColumnVector(boolean nulls, boolean repeating, int size, Random rand) {
        double repeatingValue;
        DoubleColumnVector dcv = new DoubleColumnVector(size);
        dcv.noNulls = !nulls;
        dcv.isRepeating = repeating;
        while ((repeatingValue = rand.nextDouble()) == 0.0) {
        }
        int nullFrequency = ColumnVectorGenUtil.generateNullFrequency(rand);
        for (int i = 0; i < size; ++i) {
            if (nulls && (repeating || i % nullFrequency == 0)) {
                dcv.isNull[i] = true;
                dcv.vector[i] = Double.NaN;
                continue;
            }
            dcv.isNull[i] = false;
            double d = dcv.vector[i] = repeating ? repeatingValue : rand.nextDouble();
            if (dcv.vector[i] != 0.0) continue;
            --i;
        }
        return dcv;
    }

    public static DecimalColumnVector generateDecimalColumnVector(DecimalTypeInfo typeInfo, boolean nulls, boolean repeating, int size, Random rand) {
        DecimalColumnVector dcv = new DecimalColumnVector(size, typeInfo.precision(), typeInfo.scale());
        dcv.noNulls = !nulls;
        dcv.isRepeating = repeating;
        HiveDecimalWritable repeatingValue = new HiveDecimalWritable();
        do {
            repeatingValue.set(HiveDecimal.create((String)Double.valueOf(rand.nextDouble()).toString()).setScale((int)((short)typeInfo.scale()), 4));
        } while (repeatingValue.getHiveDecimal().doubleValue() == 0.0);
        int nullFrequency = ColumnVectorGenUtil.generateNullFrequency(rand);
        for (int i = 0; i < size; ++i) {
            if (nulls && (repeating || i % nullFrequency == 0)) {
                dcv.isNull[i] = true;
                dcv.vector[i] = null;
                continue;
            }
            dcv.isNull[i] = false;
            if (repeating) {
                dcv.vector[i].set(repeatingValue);
            } else {
                dcv.vector[i].set(HiveDecimal.create((String)Double.valueOf(rand.nextDouble()).toString()).setScale((int)((short)typeInfo.scale()), 4));
            }
            if (dcv.vector[i].getHiveDecimal().doubleValue() != 0.0) continue;
            --i;
        }
        return dcv;
    }

    private static int generateNullFrequency(Random rand) {
        return 60 + rand.nextInt(20);
    }
}

