/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Objects;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.udf.generic.InstantFormatterCache;

final class InstantDateTimeFormatter
extends InstantFormatterCache<DateTimeFormatter> {
    InstantDateTimeFormatter(ZoneId zoneId, ResolverStyle resolverStyle) {
        super(zoneId, (String s) -> new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern((String)s).toFormatter().withResolverStyle(resolverStyle).withZone(zoneId));
    }

    @Override
    public Instant parse(String text) throws RuntimeException {
        Objects.requireNonNull(text);
        Timestamp timestamp = Timestamp.valueOf((String)text);
        TimestampTZ timestampTZ = TimestampTZUtil.convert((Timestamp)timestamp, (ZoneId)this.zoneId);
        return Instant.ofEpochSecond(timestampTZ.getEpochSecond(), timestampTZ.getNanos());
    }

    @Override
    public Instant parse(String text, String pattern) {
        Timestamp timestamp;
        Objects.requireNonNull(text);
        Objects.requireNonNull(pattern);
        DateTimeFormatter formatter = (DateTimeFormatter)this.getFormatter(pattern);
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(text, formatter).withZoneSameInstant(this.zoneId);
            timestamp = new Timestamp(zonedDateTime.toLocalDateTime());
        }
        catch (DateTimeException e1) {
            LocalDate localDate = LocalDate.parse(text, formatter);
            timestamp = new Timestamp(localDate.atStartOfDay());
        }
        return TimestampTZUtil.convert((Timestamp)timestamp, (ZoneId)this.zoneId).toInstant();
    }

    @Override
    public String format(Instant instant) {
        return this.format(instant, "uuuu-MM-dd HH:mm:ss");
    }

    @Override
    public String format(Instant instant, String pattern) {
        DateTimeFormatter formatter = (DateTimeFormatter)this.getFormatter(pattern);
        ZonedDateTime zonedDT = ZonedDateTime.ofInstant(instant, this.zoneId);
        return zonedDT.format(formatter);
    }
}

