/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="op", value="a op b - Returns the result of operation")
public abstract class GenericUDFBaseCompare
extends GenericUDFBaseBinary {
    protected transient ObjectInspector[] argumentOIs;
    protected transient GenericUDFUtils.ReturnObjectInspectorResolver conversionHelper = null;
    protected ObjectInspector compareOI;
    protected CompareType compareType;
    protected transient ObjectInspectorConverters.Converter converter0;
    protected transient ObjectInspectorConverters.Converter converter1;
    protected transient StringObjectInspector soi0;
    protected transient StringObjectInspector soi1;
    protected transient IntObjectInspector ioi0;
    protected transient IntObjectInspector ioi1;
    protected transient LongObjectInspector loi0;
    protected transient LongObjectInspector loi1;
    protected transient ByteObjectInspector byoi0;
    protected transient ByteObjectInspector byoi1;
    protected transient BooleanObjectInspector boi0;
    protected transient BooleanObjectInspector boi1;
    protected final BooleanWritable result = new BooleanWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector.Category c2;
        if (arguments.length != 2) {
            throw new UDFArgumentException(this.opName + " requires two arguments.");
        }
        this.argumentOIs = arguments;
        ObjectInspector.Category c1 = arguments[0].getCategory();
        if (c1 != (c2 = arguments[1].getCategory())) {
            throw new UDFArgumentException("Type mismatch in " + this.opName + "(" + c1 + "," + c2 + ")");
        }
        if (!this.supportsCategory(c1)) {
            throw new UDFArgumentException(this.opName + " does not support " + c1 + " types");
        }
        switch (c1) {
            case PRIMITIVE: {
                this.initForPrimitives(arguments[0], arguments[1]);
                break;
            }
            case MAP: 
            case STRUCT: 
            case LIST: {
                this.initForNonPrimitives(arguments[0], arguments[1]);
                break;
            }
            default: {
                throw new AssertionError((Object)("Missing init method for " + c1 + " types"));
            }
        }
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    protected boolean supportsCategory(ObjectInspector.Category c) {
        return c == ObjectInspector.Category.PRIMITIVE;
    }

    private void initForPrimitives(ObjectInspector arg0, ObjectInspector arg1) throws UDFArgumentException {
        assert (arg0.getCategory() == ObjectInspector.Category.PRIMITIVE);
        assert (arg1.getCategory() == ObjectInspector.Category.PRIMITIVE);
        TypeInfo type0 = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)arg0);
        TypeInfo type1 = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)arg1);
        if (type0.equals((Object)TypeInfoFactory.stringTypeInfo) && type1.equals((Object)TypeInfoFactory.stringTypeInfo)) {
            this.soi0 = (StringObjectInspector)arg0;
            this.soi1 = (StringObjectInspector)arg1;
            this.compareType = this.soi0.preferWritable() || this.soi1.preferWritable() ? CompareType.COMPARE_TEXT : CompareType.COMPARE_STRING;
        } else if (type0.equals((Object)TypeInfoFactory.intTypeInfo) && type1.equals((Object)TypeInfoFactory.intTypeInfo)) {
            this.compareType = CompareType.COMPARE_INT;
            this.ioi0 = (IntObjectInspector)arg0;
            this.ioi1 = (IntObjectInspector)arg1;
        } else if (type0.equals((Object)TypeInfoFactory.longTypeInfo) && type1.equals((Object)TypeInfoFactory.longTypeInfo)) {
            this.compareType = CompareType.COMPARE_LONG;
            this.loi0 = (LongObjectInspector)arg0;
            this.loi1 = (LongObjectInspector)arg1;
        } else if (type0.equals((Object)TypeInfoFactory.byteTypeInfo) && type1.equals((Object)TypeInfoFactory.byteTypeInfo)) {
            this.compareType = CompareType.COMPARE_BYTE;
            this.byoi0 = (ByteObjectInspector)arg0;
            this.byoi1 = (ByteObjectInspector)arg1;
        } else if (type0.equals((Object)TypeInfoFactory.booleanTypeInfo) && type1.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
            this.compareType = CompareType.COMPARE_BOOL;
            this.boi0 = (BooleanObjectInspector)arg0;
            this.boi1 = (BooleanObjectInspector)arg1;
        } else if (type0 == type1 || TypeInfoUtils.doPrimitiveCategoriesMatch((TypeInfo)type0, (TypeInfo)type1)) {
            this.compareType = CompareType.SAME_TYPE;
        } else {
            this.compareType = CompareType.NEED_CONVERT;
            TypeInfo compareType = FunctionRegistry.getCommonClassForComparison(type0, type1);
            this.compareOI = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)(compareType == null ? TypeInfoFactory.doubleTypeInfo : compareType));
            this.converter0 = ObjectInspectorConverters.getConverter((ObjectInspector)arg0, (ObjectInspector)this.compareOI);
            this.converter1 = ObjectInspectorConverters.getConverter((ObjectInspector)arg1, (ObjectInspector)this.compareOI);
            this.checkConversionAllowed(arg0, this.compareOI);
            this.checkConversionAllowed(arg1, this.compareOI);
        }
    }

    private void initForNonPrimitives(ObjectInspector arg0, ObjectInspector arg1) throws UDFArgumentException {
        TypeInfo type1;
        assert (arg0.getCategory() != ObjectInspector.Category.PRIMITIVE);
        assert (arg1.getCategory() != ObjectInspector.Category.PRIMITIVE);
        assert (arg0.getCategory() == arg1.getCategory());
        TypeInfo type0 = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)arg0);
        if (!type0.equals((Object)(type1 = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)arg1)))) {
            throw new UDFArgumentException("Type mismatch in " + this.opName + "(" + type0 + "," + type1 + ")");
        }
        this.compareType = CompareType.SAME_TYPE;
    }

    protected void checkConversionAllowed(ObjectInspector argOI, ObjectInspector compareOI) throws UDFArgumentException {
        if (this.primitiveGroupOf(argOI) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP) {
            return;
        }
        SessionState ss = SessionState.get();
        if (ss != null && ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STRICT_TIMESTAMP_CONVERSION) && this.primitiveGroupOf(compareOI) == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP) {
            throw new UDFArgumentException("Casting DATE/TIMESTAMP to NUMERIC is prohibited (" + HiveConf.ConfVars.HIVE_STRICT_TIMESTAMP_CONVERSION + ")");
        }
    }

    protected PrimitiveObjectInspectorUtils.PrimitiveGrouping primitiveGroupOf(ObjectInspector oi) {
        if (oi instanceof PrimitiveObjectInspector) {
            PrimitiveObjectInspector.PrimitiveCategory category = ((PrimitiveObjectInspector)oi).getPrimitiveCategory();
            PrimitiveObjectInspectorUtils.PrimitiveGrouping group = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)category);
            return group;
        }
        return null;
    }

    public Integer compare(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        Object o1 = arguments[1].get();
        if (o1 == null) {
            return null;
        }
        if (this.compareType == CompareType.NEED_CONVERT) {
            Object converted_o0 = this.converter0.convert(o0);
            if (converted_o0 == null) {
                return null;
            }
            Object converted_o1 = this.converter1.convert(o1);
            if (converted_o1 == null) {
                return null;
            }
            return ObjectInspectorUtils.compare((Object)converted_o0, (ObjectInspector)this.compareOI, (Object)converted_o1, (ObjectInspector)this.compareOI);
        }
        return ObjectInspectorUtils.compare((Object)o0, (ObjectInspector)this.argumentOIs[0], (Object)o1, (ObjectInspector)this.argumentOIs[1]);
    }

    public static enum CompareType {
        COMPARE_STRING,
        COMPARE_TEXT,
        COMPARE_INT,
        COMPARE_LONG,
        COMPARE_BYTE,
        COMPARE_BOOL,
        SAME_TYPE,
        NEED_CONVERT;

    }
}

