/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLogUtils;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="approx_distinct", value="_FUNC_(x) - generate an approximate distinct from input column")
public class GenericUDAFApproximateDistinct
extends AbstractGenericUDAFResolver {
    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        return this.getEvaluator(info.getParameters());
    }

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Function only takes 1 parameter");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE && parameters[0].getCategory() != ObjectInspector.Category.STRUCT) {
            throw new UDFArgumentTypeException(1, "Only primitive/struct rows are accepted but " + parameters[0].getTypeName() + " was passed.");
        }
        return new CountApproximateDistinctEvaluator();
    }

    public static final class CountApproximateDistinctEvaluator
    extends HyperLogLogEvaluator {
        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            ObjectInspector hyperloglog = super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.FINAL || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
            }
            return hyperloglog;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HyperLogLog hll = ((HyperLogLogBuffer)agg).hll;
            return new LongWritable(hll.count());
        }
    }

    public static class HyperLogLogEvaluator
    extends GenericUDAFEvaluator {
        ObjectInspector inputOI;
        WritableBinaryObjectInspector partialOI;
        ByteArrayOutputStream output = new ByteArrayOutputStream();

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            this.partialOI = PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
            switch (m) {
                case PARTIAL1: {
                    this.inputOI = parameters[0];
                    return this.partialOI;
                }
                case PARTIAL2: {
                    return this.partialOI;
                }
                case FINAL: 
                case COMPLETE: {
                    return this.partialOI;
                }
            }
            throw new IllegalArgumentException("Unknown UDAF mode " + m);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new HyperLogLogBuffer();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] args) throws HiveException {
            if (args[0] == null) {
                return;
            }
            HyperLogLog hll = ((HyperLogLogBuffer)agg).hll;
            Object val = ObjectInspectorUtils.copyToStandardJavaObject((Object)args[0], (ObjectInspector)this.inputOI);
            try {
                if (val instanceof Byte || val instanceof Character || val instanceof Short) {
                    hll.add((long)val.hashCode());
                } else if (val instanceof Integer) {
                    hll.addInt(((Integer)val).intValue());
                } else if (val instanceof Long) {
                    hll.addLong(((Long)val).longValue());
                } else if (val instanceof Float) {
                    hll.addFloat(((Float)val).floatValue());
                } else if (val instanceof Double) {
                    hll.addDouble(((Double)val).doubleValue());
                } else if (val instanceof String) {
                    hll.addString(val.toString());
                } else if (val instanceof HiveDecimal) {
                    hll.addToEstimator((HiveDecimal)val);
                } else if (val instanceof Date) {
                    hll.addInt(((Date)val).toEpochDay());
                } else if (val instanceof Timestamp) {
                    hll.addLong(((Timestamp)val).toEpochMilli());
                } else if (val instanceof HiveIntervalDayTime) {
                    hll.addLong(((HiveIntervalDayTime)val).getTotalSeconds());
                } else if (val instanceof HiveBaseChar) {
                    hll.addString(((HiveBaseChar)val).toString());
                } else {
                    this.output.reset();
                    ObjectOutputStream out = new ObjectOutputStream(this.output);
                    out.writeObject(val);
                    byte[] key = this.output.toByteArray();
                    hll.addBytes(key);
                }
            }
            catch (IOException ioe) {
                throw new HiveException((Throwable)ioe);
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HyperLogLog hll = ((HyperLogLogBuffer)agg).hll;
            this.output.reset();
            try {
                HyperLogLogUtils.serializeHLL((OutputStream)this.output, (HyperLogLog)hll);
            }
            catch (IOException ioe) {
                throw new HiveException((Throwable)ioe);
            }
            return new BytesWritable(this.output.toByteArray());
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            BytesWritable bw = this.partialOI.getPrimitiveWritableObject(partial);
            HyperLogLog hll = ((HyperLogLogBuffer)agg).hll;
            this.merge(hll, bw);
        }

        protected void merge(HyperLogLog hll, BytesWritable bw) throws HiveException {
            try {
                ByteArrayInputStream input = new ByteArrayInputStream(bw.getBytes(), 0, bw.getLength());
                HyperLogLog hll2 = HyperLogLogUtils.deserializeHLL((InputStream)input);
                hll.merge(hll2);
                input.close();
            }
            catch (IOException ioe) {
                throw new HiveException((Throwable)ioe);
            }
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((HyperLogLogBuffer)agg).reset();
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            HyperLogLog hll = ((HyperLogLogBuffer)agg).hll;
            this.output.reset();
            try {
                HyperLogLogUtils.serializeHLL((OutputStream)this.output, (HyperLogLog)hll);
            }
            catch (IOException ioe) {
                throw new HiveException((Throwable)ioe);
            }
            return new BytesWritable(this.output.toByteArray());
        }
    }

    static final class HyperLogLogBuffer
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        public HyperLogLog hll;

        public HyperLogLogBuffer() {
            this.reset();
        }

        @Override
        public int estimate() {
            return 4096;
        }

        public void reset() {
            this.hll = HyperLogLog.builder().setNumRegisterIndexBits(12).build();
        }
    }
}

