/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.Calendar;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMinuteDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMinuteString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMinuteTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="minute", value="_FUNC_(param) - Returns the minute component of the string/timestamp/interval", extended="param can be one of:\n1. A string in the format of 'yyyy-MM-dd HH:mm:ss' or 'HH:mm:ss'.\n2. A timestamp value\n3. A day-time interval valueExample:\n   > SELECT _FUNC_('2009-07-30 12:58:59') FROM src LIMIT 1;\n  58\n  > SELECT _FUNC_('12:58:59') FROM src LIMIT 1;\n  58")
@VectorizedExpressions(value={VectorUDFMinuteDate.class, VectorUDFMinuteString.class, VectorUDFMinuteTimestamp.class})
@NDV(maxNdv=60L)
public class UDFMinute
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[1];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[1];
    private final IntWritable output = new IntWritable();
    private final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 1, 1);
        this.checkArgPrimitive(arguments, 0);
        switch (((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory()) {
            case INTERVAL_DAY_TIME: {
                this.inputTypes[0] = PrimitiveObjectInspector.PrimitiveCategory.INTERVAL_DAY_TIME;
                this.converters[0] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector);
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMPLOCALTZ: 
            case VOID: {
                this.obtainTimestampConverter(arguments, 0, this.inputTypes, this.converters);
                break;
            }
            default: {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getFuncName());
                sb.append(" does not take ");
                sb.append(((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory());
                sb.append(" type");
                throw new UDFArgumentTypeException(0, sb.toString());
            }
        }
        WritableIntObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        switch (this.inputTypes[0]) {
            case INTERVAL_DAY_TIME: {
                HiveIntervalDayTime intervalDayTime = this.getIntervalDayTimeValue(arguments, 0, this.inputTypes, this.converters);
                if (intervalDayTime == null) {
                    return null;
                }
                this.output.set(intervalDayTime.getMinutes());
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMPLOCALTZ: 
            case VOID: {
                Timestamp ts = this.getTimestampValue(arguments, 0, this.converters);
                if (ts == null) {
                    return null;
                }
                this.calendar.setTimeInMillis(ts.toEpochMilli());
                this.output.set(this.calendar.get(12));
            }
        }
        return this.output;
    }

    @Override
    protected String getFuncName() {
        return "minute";
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }
}

