/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.ql.ErrorMsg;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CompactionException
extends RuntimeException {
    private final ErrorMsg canonicalErrorMsg;
    private final String remoteErrorMsg;

    public CompactionException() {
        this(null, null, ErrorMsg.GENERIC_ERROR, new String[0]);
    }

    public CompactionException(String message) {
        this(message, null);
    }

    public CompactionException(Throwable cause) {
        this(cause, null, ErrorMsg.GENERIC_ERROR, new String[0]);
    }

    public CompactionException(String message, Throwable cause) {
        super(message, cause);
        this.canonicalErrorMsg = ErrorMsg.GENERIC_ERROR;
        this.remoteErrorMsg = null;
    }

    public CompactionException(ErrorMsg message, String ... msgArgs) {
        this(null, null, message, msgArgs);
    }

    public CompactionException(Throwable cause, ErrorMsg errorMsg, String ... msgArgs) {
        this(cause, null, errorMsg, msgArgs);
    }

    public CompactionException(Throwable cause, ErrorMsg errorMsg) {
        this(cause, null, errorMsg, new String[0]);
    }

    public CompactionException(ErrorMsg errorMsg) {
        this(null, null, errorMsg, new String[0]);
    }

    public CompactionException(Throwable cause, String remErrMsg, ErrorMsg errorMsg, String ... msgArgs) {
        super(errorMsg.format(msgArgs), cause);
        this.canonicalErrorMsg = errorMsg;
        this.remoteErrorMsg = remErrMsg;
    }

    public ErrorMsg getCanonicalErrorMsg() {
        return this.canonicalErrorMsg;
    }

    public String getRemoteErrorMsg() {
        return this.remoteErrorMsg;
    }
}

