/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapper;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.RelTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.RuntimeStatsPersister;
import org.apache.hadoop.hive.ql.plan.mapper.PersistedRuntimeStats;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetastoreStatsConnector
implements StatsSource {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreStatsConnector.class);
    private final StatsSource ss;
    private ExecutorService executor;

    MetastoreStatsConnector(int cacheSize, int batchSize, StatsSource ss) {
        this.ss = ss;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Metastore-RuntimeStats-Loader-%d").daemon(true).build());
        this.executor.submit(new RuntimeStatsLoader(cacheSize, batchSize));
    }

    @Override
    public boolean canProvideStatsFor(Class<?> clazz) {
        return this.ss.canProvideStatsFor(clazz);
    }

    @Override
    public Optional<OperatorStats> lookup(OpTreeSignature treeSig) {
        return this.ss.lookup(treeSig);
    }

    @Override
    public Optional<OperatorStats> lookup(RelTreeSignature treeSig) {
        return this.ss.lookup(treeSig);
    }

    @Override
    public void load(List<PersistedRuntimeStats> statList) {
        if (statList.size() == 0) {
            return;
        }
        this.ss.load(statList);
        this.executor.submit(new RuntimeStatsSubmitter(statList));
    }

    private RuntimeStat encode(List<PersistedRuntimeStats> list) throws IOException {
        String payload = RuntimeStatsPersister.INSTANCE.encode(new ArrayList<PersistedRuntimeStats>(list));
        RuntimeStat rs = new RuntimeStat();
        rs.setWeight(list.size());
        rs.setPayload(ByteBuffer.wrap(payload.getBytes(Charsets.UTF_8)));
        return rs;
    }

    private List<PersistedRuntimeStats> decode(RuntimeStat rs) throws IOException {
        List rsm = RuntimeStatsPersister.INSTANCE.decode(rs.getPayload(), List.class);
        return rsm;
    }

    public void destroy() {
        this.executor.shutdown();
    }

    static void logException(String msg, Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(msg, (Throwable)e);
        } else {
            LOG.info(msg + ": " + e.getMessage());
        }
    }

    private class RuntimeStatsLoader
    implements Runnable {
        private int maxEntriesToLoad;
        private int batchSize;

        public RuntimeStatsLoader(int maxEntriesToLoad, int batchSize) {
            this.maxEntriesToLoad = maxEntriesToLoad;
            this.batchSize = batchSize <= 0 ? -1 : batchSize;
        }

        @Override
        public void run() {
            int lastCreateTime = Integer.MAX_VALUE;
            int loadedEntries = 0;
            try {
                List rs;
                while ((rs = Hive.get().getMSC().getRuntimeStats(this.batchSize, lastCreateTime)).size() != 0) {
                    for (RuntimeStat thriftStat : rs) {
                        loadedEntries += thriftStat.getWeight();
                        lastCreateTime = Math.min(lastCreateTime, thriftStat.getCreateTime() - 1);
                        try {
                            MetastoreStatsConnector.this.ss.load(MetastoreStatsConnector.this.decode(thriftStat));
                        }
                        catch (IOException e) {
                            MetastoreStatsConnector.logException("Exception while loading runtime stats", e);
                        }
                    }
                    if (this.batchSize > 0 && loadedEntries < this.maxEntriesToLoad) continue;
                    break;
                }
            }
            catch (HiveException | TException e) {
                MetastoreStatsConnector.logException("Exception while reading metastore runtime stats", (Exception)e);
            }
        }
    }

    class RuntimeStatsSubmitter
    implements Runnable {
        private List<PersistedRuntimeStats> list;

        public RuntimeStatsSubmitter(List<PersistedRuntimeStats> statList) {
            this.list = statList;
        }

        @Override
        public void run() {
            try {
                RuntimeStat rec = MetastoreStatsConnector.this.encode(this.list);
                Hive.get().getMSC().addRuntimeStat(rec);
            }
            catch (IOException | HiveException | TException e) {
                MetastoreStatsConnector.logException("Exception while persisting runtime stat", (Exception)e);
            }
        }
    }
}

