/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.constraint.Constraints;
import org.apache.hadoop.hive.ql.ddl.table.constraint.add.AlterTableAddConstraintDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class AddPrimaryKeyHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        List pks;
        AddPrimaryKeyMessage msg = this.deserializer.getAddPrimaryKeyMessage(context.dmd.getPayload());
        try {
            pks = msg.getPrimaryKeys();
        }
        catch (Exception e) {
            if (!(e instanceof SemanticException)) {
                throw new SemanticException("Error reading message members", (Throwable)e);
            }
            throw (SemanticException)((Object)e);
        }
        ArrayList tasks = new ArrayList();
        if (pks.isEmpty()) {
            return tasks;
        }
        String actualDbName = context.isDbNameEmpty() ? ((SQLPrimaryKey)pks.get(0)).getTable_db() : context.dbName;
        String actualTblName = ((SQLPrimaryKey)pks.get(0)).getTable_name();
        TableName tName = TableName.fromString((String)actualTblName, null, (String)actualDbName);
        for (SQLPrimaryKey pk : pks) {
            pk.setTable_db(actualDbName);
            pk.setTable_name(actualTblName);
        }
        Constraints constraints = new Constraints(pks, null, null, null, null, null);
        AlterTableAddConstraintDesc addConstraintsDesc = new AlterTableAddConstraintDesc(tName, context.eventOnlyReplicationSpec(), constraints);
        Task<DDLWork> addConstraintsTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, addConstraintsDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        tasks.add(addConstraintsTask);
        context.log.debug("Added add constrains task : {}:{}", (Object)addConstraintsTask.getId(), (Object)actualTblName);
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, null);
        return Collections.singletonList(addConstraintsTask);
    }
}

